<?php
// languages/fr.php - French Language File
// فایل زبان فرانسوی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Bienvenue',
    'home' => 'Accueil',
    'about' => 'À propos',
    'contact' => 'Contact',
    'login' => 'Connexion',
    'register' => 'Inscription',
    'logout' => 'Déconnexion',
    'dashboard' => 'Tableau de bord',
    'profile' => 'Profil',
    'settings' => 'Paramètres',
    'help' => 'Aide',
    'support' => 'Support',
    'language' => 'Langue',
    'currency' => 'Devise',
    'search' => 'Rechercher',
    'loading' => 'Chargement...',
    'error' => 'Erreur',
    'success' => 'Succès',
    'warning' => 'Avertissement',
    'info' => 'Information',
    'close' => 'Fermer',
    'save' => 'Enregistrer',
    'cancel' => 'Annuler',
    'delete' => 'Supprimer',
    'edit' => 'Modifier',
    'view' => 'Voir',
    'back' => 'Retour',
    'next' => 'Suivant',
    'previous' => 'Précédent',
    'submit' => 'Soumettre',
    'confirm' => 'Confirmer',
    'yes' => 'Oui',
    'no' => 'Non',
    'ok' => 'OK',
    'continue' => 'Continuer',
    'finish' => 'Terminer',
    'start' => 'Commencer',
    'stop' => 'Arrêter',
    'pause' => 'Pause',
    'resume' => 'Reprendre',
    'reset' => 'Réinitialiser',
    'refresh' => 'Actualiser',
    'update' => 'Mettre à jour',
    'upgrade' => 'Mise à niveau',
    'download' => 'Télécharger',
    'upload' => 'Téléverser',
    'share' => 'Partager',
    'copy' => 'Copier',
    'print' => 'Imprimer',
    'export' => 'Exporter',
    'import' => 'Importer',
    
    // Navigation
    'nav_home' => 'Accueil',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Sports',
    'nav_live' => 'En direct',
    'nav_promotions' => 'Promotions',
    'nav_wallet' => 'Portefeuille',
    'nav_history' => 'Historique',
    'nav_support' => 'Support',
    
    // Authentication
    'auth_login_title' => 'Connectez-vous à votre compte',
    'auth_register_title' => 'Créer un nouveau compte',
    'auth_email' => 'E-mail',
    'auth_password' => 'Mot de passe',
    'auth_confirm_password' => 'Confirmer le mot de passe',
    'auth_remember_me' => 'Se souvenir de moi',
    'auth_forgot_password' => 'Mot de passe oublié ?',
    'auth_no_account' => 'Pas de compte ?',
    'auth_have_account' => 'Déjà un compte ?',
    'auth_create_account' => 'Créer un compte',
    'auth_login_now' => 'Se connecter maintenant',
    'auth_first_name' => 'Prénom',
    'auth_last_name' => 'Nom de famille',
    'auth_phone' => 'Numéro de téléphone',
    'auth_birth_date' => 'Date de naissance',
    'auth_country' => 'Pays',
    'auth_city' => 'Ville',
    'auth_address' => 'Adresse',
    'auth_agree_terms' => 'J\'accepte les conditions générales',
    'auth_agree_privacy' => 'J\'accepte la politique de confidentialité',
    'auth_login_success' => 'Connexion réussie',
    'auth_register_success' => 'Compte créé avec succès',
    'auth_logout_success' => 'Déconnexion réussie',
    'auth_invalid_credentials' => 'Identifiants invalides',
    'auth_email_exists' => 'E-mail déjà utilisé',
    'auth_weak_password' => 'Mot de passe faible',
    'auth_password_mismatch' => 'Les mots de passe ne correspondent pas',
    
    // Dashboard
    'dashboard_welcome' => 'Bienvenue, {name}',
    'dashboard_balance' => 'Solde',
    'dashboard_total_bets' => 'Total des paris',
    'dashboard_total_wins' => 'Total des gains',
    'dashboard_win_rate' => 'Taux de victoire',
    'dashboard_recent_games' => 'Jeux récents',
    'dashboard_quick_deposit' => 'Dépôt rapide',
    'dashboard_quick_withdraw' => 'Retrait rapide',
    'dashboard_notifications' => 'Notifications',
    'dashboard_no_notifications' => 'Aucune nouvelle notification',
    'dashboard_view_all' => 'Voir tout',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Machines à sous',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Roulette',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Dés',
    'games_mines' => 'Mines',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Roue',
    'games_keno' => 'Keno',
    'games_scratch' => 'Cartes à gratter',
    'games_play_now' => 'Jouer maintenant',
    'games_demo_mode' => 'Mode démo',
    'games_real_mode' => 'Mode réel',
    'games_min_bet' => 'Mise min.',
    'games_max_bet' => 'Mise max.',
    'games_max_win' => 'Gain max.',
    'games_rtp' => 'Taux de retour',
    'games_volatility' => 'Volatilité',
    'games_provider' => 'Fournisseur',
    
    // Betting
    'bet_amount' => 'Montant du pari',
    'bet_place' => 'Placer le pari',
    'bet_cancel' => 'Annuler le pari',
    'bet_cashout' => 'Encaisser',
    'bet_auto' => 'Pari automatique',
    'bet_manual' => 'Pari manuel',
    'bet_multiplier' => 'Multiplicateur',
    'bet_profit' => 'Profit',
    'bet_loss' => 'Perte',
    'bet_win' => 'Gain',
    'bet_pending' => 'En attente',
    'bet_settled' => 'Réglé',
    'bet_void' => 'Annulé',
    'bet_history' => 'Historique des paris',
    'bet_statistics' => 'Statistiques des paris',
    'bet_limits' => 'Limites de paris',
    'bet_responsible' => 'Jeu responsable',
    
    // Wallet
    'wallet_balance' => 'Solde du portefeuille',
    'wallet_deposit' => 'Dépôt',
    'wallet_withdraw' => 'Retrait',
    'wallet_transfer' => 'Transfert',
    'wallet_history' => 'Historique du portefeuille',
    'wallet_pending' => 'En attente',
    'wallet_completed' => 'Terminé',
    'wallet_failed' => 'Échoué',
    'wallet_cancelled' => 'Annulé',
    'wallet_min_deposit' => 'Dépôt min.',
    'wallet_max_deposit' => 'Dépôt max.',
    'wallet_min_withdraw' => 'Retrait min.',
    'wallet_max_withdraw' => 'Retrait max.',
    'wallet_fee' => 'Frais',
    'wallet_processing_time' => 'Temps de traitement',
    'wallet_payment_method' => 'Méthode de paiement',
    'wallet_card' => 'Carte',
    'wallet_bank' => 'Banque',
    'wallet_crypto' => 'Cryptomonnaie',
    'wallet_ewallet' => 'Portefeuille électronique',
    
    // Sports Betting
    'sports_football' => 'Football',
    'sports_basketball' => 'Basketball',
    'sports_tennis' => 'Tennis',
    'sports_baseball' => 'Baseball',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'Football américain',
    'sports_boxing' => 'Boxe',
    'sports_mma' => 'Arts martiaux mixtes',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Course',
    'sports_esports' => 'E-sport',
    'sports_live_betting' => 'Paris en direct',
    'sports_pre_match' => 'Avant-match',
    'sports_odds' => 'Cotes',
    'sports_handicap' => 'Handicap',
    'sports_over_under' => 'Plus/Moins',
    'sports_both_teams_score' => 'Les deux équipes marquent',
    'sports_correct_score' => 'Score exact',
    'sports_first_goal' => 'Premier but',
    'sports_match_winner' => 'Vainqueur du match',
    'sports_tournament_winner' => 'Vainqueur du tournoi',
    
    // Promotions
    'promo_welcome_bonus' => 'Bonus de bienvenue',
    'promo_deposit_bonus' => 'Bonus de dépôt',
    'promo_reload_bonus' => 'Bonus de rechargement',
    'promo_cashback' => 'Remboursement',
    'promo_free_spins' => 'Tours gratuits',
    'promo_free_bet' => 'Pari gratuit',
    'promo_tournament' => 'Tournoi',
    'promo_loyalty' => 'Programme de fidélité',
    'promo_vip' => 'Programme VIP',
    'promo_refer_friend' => 'Parrainer un ami',
    'promo_code' => 'Code promo',
    'promo_terms' => 'Conditions de la promotion',
    'promo_wagering' => 'Conditions de mise',
    'promo_expiry' => 'Date d\'expiration',
    'promo_claim' => 'Réclamer',
    'promo_claimed' => 'Réclamé',
    'promo_expired' => 'Expiré',
    'promo_active' => 'Actif',
    'promo_completed' => 'Terminé',
    
    // Profile
    'profile_personal_info' => 'Informations personnelles',
    'profile_account_settings' => 'Paramètres du compte',
    'profile_security' => 'Sécurité',
    'profile_preferences' => 'Préférences',
    'profile_verification' => 'Vérification',
    'profile_documents' => 'Documents',
    'profile_limits' => 'Limites',
    'profile_self_exclusion' => 'Auto-exclusion',
    'profile_responsible_gaming' => 'Jeu responsable',
    'profile_notifications' => 'Notifications',
    'profile_privacy' => 'Confidentialité',
    'profile_change_password' => 'Changer le mot de passe',
    'profile_two_factor' => 'Authentification à deux facteurs',
    'profile_login_history' => 'Historique de connexion',
    'profile_device_management' => 'Gestion des appareils',
    
    // Support
    'support_contact' => 'Nous contacter',
    'support_live_chat' => 'Chat en direct',
    'support_email' => 'E-mail',
    'support_phone' => 'Téléphone',
    'support_faq' => 'Questions fréquentes',
    'support_help_center' => 'Centre d\'aide',
    'support_ticket' => 'Ticket de support',
    'support_create_ticket' => 'Créer un ticket',
    'support_ticket_status' => 'Statut du ticket',
    'support_priority' => 'Priorité',
    'support_category' => 'Catégorie',
    'support_subject' => 'Sujet',
    'support_message' => 'Message',
    'support_attachment' => 'Pièce jointe',
    'support_response' => 'Réponse',
    'support_resolved' => 'Résolu',
    'support_pending' => 'En attente',
    'support_closed' => 'Fermé',
    
    // Notifications
    'notif_new_message' => 'Nouveau message',
    'notif_deposit_success' => 'Dépôt réussi',
    'notif_withdraw_success' => 'Retrait réussi',
    'notif_bet_won' => 'Pari gagné !',
    'notif_bet_lost' => 'Pari perdu',
    'notif_bonus_received' => 'Bonus reçu',
    'notif_promotion_available' => 'Promotion disponible',
    'notif_account_verified' => 'Compte vérifié',
    'notif_security_alert' => 'Alerte de sécurité',
    'notif_maintenance' => 'Maintenance du système',
    'notif_mark_read' => 'Marquer comme lu',
    'notif_mark_all_read' => 'Tout marquer comme lu',
    'notif_delete' => 'Supprimer la notification',
    'notif_settings' => 'Paramètres de notification',
    
    // Errors
    'error_404' => 'Page non trouvée',
    'error_500' => 'Erreur du serveur',
    'error_403' => 'Accès refusé',
    'error_401' => 'Non autorisé',
    'error_400' => 'Requête invalide',
    'error_network' => 'Erreur réseau',
    'error_timeout' => 'Délai d\'attente dépassé',
    'error_invalid_input' => 'Saisie invalide',
    'error_required_field' => 'Ce champ est requis',
    'error_invalid_email' => 'E-mail invalide',
    'error_invalid_phone' => 'Numéro de téléphone invalide',
    'error_min_length' => 'Longueur minimale {min} caractères',
    'error_max_length' => 'Longueur maximale {max} caractères',
    'error_min_value' => 'Valeur minimale {min}',
    'error_max_value' => 'Valeur maximale {max}',
    'error_insufficient_balance' => 'Solde insuffisant',
    'error_bet_limit_exceeded' => 'Limite de pari dépassée',
    'error_game_unavailable' => 'Jeu indisponible',
    'error_maintenance' => 'Système en maintenance',
    
    // Success Messages
    'success_saved' => 'Enregistré avec succès',
    'success_updated' => 'Mis à jour avec succès',
    'success_deleted' => 'Supprimé avec succès',
    'success_sent' => 'Envoyé avec succès',
    'success_verified' => 'Vérifié avec succès',
    'success_activated' => 'Activé avec succès',
    'success_deactivated' => 'Désactivé avec succès',
    'success_password_changed' => 'Mot de passe changé avec succès',
    'success_email_sent' => 'E-mail envoyé',
    'success_settings_saved' => 'Paramètres enregistrés',
    
    // Time and Date
    'time_now' => 'maintenant',
    'time_minute_ago' => 'il y a 1 minute',
    'time_minutes_ago' => 'il y a {count} minutes',
    'time_hour_ago' => 'il y a 1 heure',
    'time_hours_ago' => 'il y a {count} heures',
    'time_day_ago' => 'il y a 1 jour',
    'time_days_ago' => 'il y a {count} jours',
    'time_week_ago' => 'il y a 1 semaine',
    'time_weeks_ago' => 'il y a {count} semaines',
    'time_month_ago' => 'il y a 1 mois',
    'time_months_ago' => 'il y a {count} mois',
    'time_year_ago' => 'il y a 1 an',
    'time_years_ago' => 'il y a {count} ans',
    
    // Days of Week
    'day_monday' => 'Lundi',
    'day_tuesday' => 'Mardi',
    'day_wednesday' => 'Mercredi',
    'day_thursday' => 'Jeudi',
    'day_friday' => 'Vendredi',
    'day_saturday' => 'Samedi',
    'day_sunday' => 'Dimanche',
    
    // Months
    'month_january' => 'Janvier',
    'month_february' => 'Février',
    'month_march' => 'Mars',
    'month_april' => 'Avril',
    'month_may' => 'Mai',
    'month_june' => 'Juin',
    'month_july' => 'Juillet',
    'month_august' => 'Août',
    'month_september' => 'Septembre',
    'month_october' => 'Octobre',
    'month_november' => 'Novembre',
    'month_december' => 'Décembre',
    
    // Footer
    'footer_about_us' => 'À propos de nous',
    'footer_terms' => 'Conditions générales',
    'footer_privacy' => 'Politique de confidentialité',
    'footer_responsible_gaming' => 'Jeu responsable',
    'footer_contact' => 'Contact',
    'footer_help' => 'Aide',
    'footer_sitemap' => 'Plan du site',
    'footer_copyright' => '© 2024 Crashify. Tous droits réservés.',
    'footer_license' => 'Licencié et réglementé',
    'footer_18_plus' => '18+ seulement',
    'footer_gamble_responsibly' => 'Jouez de manière responsable',
    
    // Legal
    'legal_terms_title' => 'Conditions générales',
    'legal_privacy_title' => 'Politique de confidentialité',
    'legal_responsible_title' => 'Jeu responsable',
    'legal_aml_title' => 'Lutte contre le blanchiment d\'argent',
    'legal_kyc_title' => 'Connaissance du client',
    'legal_complaints_title' => 'Procédures de plainte',
    'legal_licensing_title' => 'Informations de licence',
    'legal_fairness_title' => 'Équité et transparence',
    
    // Admin
    'admin_dashboard' => 'Tableau de bord admin',
    'admin_users' => 'Utilisateurs',
    'admin_transactions' => 'Transactions',
    'admin_games' => 'Jeux',
    'admin_reports' => 'Rapports',
    'admin_settings' => 'Paramètres',
    'admin_logs' => 'Journaux',
    'admin_security' => 'Sécurité',
    'admin_maintenance' => 'Maintenance',
    'admin_backup' => 'Sauvegarde',
];
?>
