<?php
// Bootstrap: redirect guests to login, logged-in users to dashboard
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/auth.php';
if (isLoggedIn()) {
    header('Location: ' . SITE_URL . '/pages/dashboard.php');
    exit;
} else {
    header('Location: ' . SITE_URL . '/pages/login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crashify - Modern Crypto Betting Platform</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            /* Default Theme - Neon Blue */
            --primary: #00d4ff;
            --primary-dark: #0099cc;
            --secondary: #1a1a2e;
            --accent: #16213e;
            --background: #0f0f23;
            --surface: #1a1a2e;
            --text: #ffffff;
            --text-secondary: #b0b0b0;
            --success: #00ff88;
            --warning: #ffaa00;
            --error: #ff4444;
            --gradient: linear-gradient(135deg, #00d4ff 0%, #0099cc 100%);
        }

        .theme-purple {
            --primary: #8b5cf6;
            --primary-dark: #7c3aed;
            --gradient: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
        }

        .theme-green {
            --primary: #10b981;
            --primary-dark: #059669;
            --gradient: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }

        .theme-orange {
            --primary: #f59e0b;
            --primary-dark: #d97706;
            --gradient: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }

        .theme-red {
            --primary: #ef4444;
            --primary-dark: #dc2626;
            --gradient: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        }

        .theme-pink {
            --primary: #ec4899;
            --primary-dark: #db2777;
            --gradient: linear-gradient(135deg, #ec4899 0%, #db2777 100%);
        }

        .theme-indigo {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --gradient: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
        }

        .theme-teal {
            --primary: #14b8a6;
            --primary-dark: #0d9488;
            --gradient: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);
        }

        .theme-yellow {
            --primary: #eab308;
            --primary-dark: #ca8a04;
            --gradient: linear-gradient(135deg, #eab308 0%, #ca8a04 100%);
        }

        .theme-cyan {
            --primary: #06b6d4;
            --primary-dark: #0891b2;
            --gradient: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
        }

        /* Header Styles */
        .header {
            background: var(--surface);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            backdrop-filter: blur(10px);
        }

        .header-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 70px;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 24px;
            font-weight: 800;
            color: var(--primary);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logo:hover {
            transform: scale(1.05);
        }

        .logo-icon {
            width: 40px;
            height: 40px;
            background: var(--gradient);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: white;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        .nav-menu {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .nav-item {
            color: var(--text);
            text-decoration: none;
            font-weight: 500;
            padding: 8px 16px;
            border-radius: 8px;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-item:hover {
            background: rgba(255, 255, 255, 0.1);
            color: var(--primary);
        }

        .nav-item.active {
            background: var(--gradient);
            color: white;
        }

        .wallet-info {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .balance-display {
            display: flex;
            align-items: center;
            gap: 15px;
            background: var(--accent);
            padding: 10px 20px;
            border-radius: 12px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .balance-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 4px;
        }

        .balance-label {
            font-size: 11px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .balance-amount {
            font-size: 14px;
            font-weight: 600;
            color: var(--primary);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
        }

        .btn-primary {
            background: var(--gradient);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 212, 255, 0.3);
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }

        .btn-outline:hover {
            background: var(--primary);
            color: white;
        }

        .notification-icon {
            position: relative;
            padding: 10px;
            border-radius: 8px;
            background: var(--accent);
            color: var(--text);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .notification-icon:hover {
            background: var(--primary);
            color: white;
        }

        .notification-badge {
            position: absolute;
            top: 5px;
            right: 5px;
            width: 8px;
            height: 8px;
            background: var(--error);
            border-radius: 50%;
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        .language-selector {
            position: relative;
        }

        .language-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            background: var(--accent);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: var(--text);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .language-btn:hover {
            background: var(--primary);
            color: white;
        }

        .flag-icon {
            width: 20px;
            height: 15px;
            border-radius: 2px;
            background-size: cover;
            background-position: center;
        }

        .theme-selector {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            background: var(--accent);
            border-radius: 8px;
            cursor: pointer;
        }

        .theme-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .theme-dot:hover {
            transform: scale(1.2);
        }

        .theme-dot.active {
            border-color: white;
            transform: scale(1.3);
        }

        /* Main Content */
        .main-content {
            margin-top: 70px;
            min-height: calc(100vh - 70px);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, var(--background) 0%, var(--accent) 100%);
            padding: 80px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="1"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }

        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            position: relative;
            z-index: 2;
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero p {
            font-size: 1.2rem;
            color: var(--text-secondary);
            margin-bottom: 40px;
            line-height: 1.8;
        }

        .hero-actions {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .hero-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            margin-top: 60px;
        }

        .stat-item {
            text-align: center;
            padding: 30px;
            background: var(--surface);
            border-radius: 16px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .stat-item:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
        }

        .stat-number {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--primary);
            margin-bottom: 10px;
        }

        .stat-label {
            color: var(--text-secondary);
            font-weight: 500;
        }

        /* Quick Access Section */
        .quick-access {
            padding: 80px 20px;
            background: var(--surface);
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .section-title {
            text-align: center;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--text);
        }

        .section-subtitle {
            text-align: center;
            color: var(--text-secondary);
            margin-bottom: 60px;
            font-size: 1.1rem;
        }

        .quick-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
        }

        .quick-card {
            background: var(--accent);
            border-radius: 20px;
            padding: 40px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .quick-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: left 0.5s ease;
        }

        .quick-card:hover::before {
            left: 100%;
        }

        .quick-card:hover {
            transform: translateY(-10px);
            border-color: var(--primary);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }

        .quick-icon {
            width: 80px;
            height: 80px;
            background: var(--gradient);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            margin: 0 auto 20px;
        }

        .quick-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--text);
        }

        .quick-description {
            color: var(--text-secondary);
            line-height: 1.6;
        }

        /* Live Events */
        .live-events {
            padding: 80px 20px;
            background: var(--background);
        }

        .events-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 20px;
        }

        .event-card {
            background: var(--surface);
            border-radius: 16px;
            padding: 25px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .event-card:hover {
            border-color: var(--primary);
            transform: translateY(-2px);
        }

        .event-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .event-league {
            font-size: 12px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .live-indicator {
            display: flex;
            align-items: center;
            gap: 6px;
            color: var(--success);
            font-size: 12px;
            font-weight: 600;
        }

        .live-dot {
            width: 8px;
            height: 8px;
            background: var(--success);
            border-radius: 50%;
            animation: pulse 1s infinite;
        }

        .event-teams {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .team {
            display: flex;
            align-items: center;
            gap: 12px;
            flex: 1;
        }

        .team-logo {
            width: 40px;
            height: 40px;
            background: var(--accent);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
        }

        .team-name {
            font-weight: 600;
            color: var(--text);
        }

        .vs-separator {
            color: var(--text-secondary);
            font-weight: 600;
            margin: 0 20px;
        }

        .event-odds {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 10px;
        }

        .odd-btn {
            background: var(--accent);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            padding: 12px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            color: var(--text);
        }

        .odd-btn:hover {
            background: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .odd-label {
            font-size: 11px;
            color: var(--text-secondary);
            margin-bottom: 4px;
        }

        .odd-value {
            font-weight: 600;
            font-size: 14px;
        }

        /* Crypto Support */
        .crypto-section {
            padding: 80px 20px;
            background: var(--surface);
        }

        .crypto-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 20px;
            margin-top: 40px;
        }

        .crypto-item {
            background: var(--accent);
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }

        .crypto-item:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
        }

        .crypto-icon {
            width: 40px;
            height: 40px;
            margin: 0 auto 10px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            background: var(--gradient);
            color: white;
        }

        .crypto-name {
            font-size: 12px;
            font-weight: 600;
            color: var(--text);
        }

        /* Footer */
        .footer {
            background: var(--accent);
            padding: 60px 20px 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .footer-content {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 40px;
        }

        .footer-section h3 {
            color: var(--primary);
            margin-bottom: 20px;
            font-weight: 600;
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 10px;
        }

        .footer-links a {
            color: var(--text-secondary);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--primary);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            color: var(--text-secondary);
        }

        .social-links {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-bottom: 20px;
        }

        .social-link {
            width: 40px;
            height: 40px;
            background: var(--surface);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .social-link:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-2px);
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .header-container {
                padding: 0 15px;
            }

            .nav-menu {
                display: none;
            }

            .hero h1 {
                font-size: 2.5rem;
            }

            .hero-actions {
                flex-direction: column;
                align-items: center;
            }

            .hero-stats {
                grid-template-columns: 1fr;
                gap: 20px;
            }

            .quick-grid {
                grid-template-columns: 1fr;
            }

            .events-grid {
                grid-template-columns: 1fr;
            }

            .balance-display {
                flex-direction: column;
                gap: 10px;
            }

            .header-actions {
                gap: 10px;
            }

            .btn {
                padding: 8px 16px;
                font-size: 12px;
            }
        }

        /* Loading Animation */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: var(--primary);
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Floating Action Button */
        .fab {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 60px;
            height: 60px;
            background: var(--gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            cursor: pointer;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .fab:hover {
            transform: scale(1.1);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.4);
        }

        /* Modals */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            z-index: 2000;
            backdrop-filter: blur(5px);
        }

        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: var(--surface);
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .modal-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 30px;
        }

        .modal-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--text);
        }

        .modal-close {
            background: none;
            border: none;
            color: var(--text-secondary);
            font-size: 24px;
            cursor: pointer;
            transition: color 0.3s ease;
        }

        .modal-close:hover {
            color: var(--primary);
        }

        /* Animations */
        .fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .slide-in {
            animation: slideIn 0.5s ease-in-out;
        }

        @keyframes slideIn {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }
    </style>
</head>
<body class="theme-blue">
    <!-- Header -->
    <header class="header">
        <div class="header-container">
            <a href="#" class="logo">
                <div class="logo-icon">
                    <i class="fas fa-bolt"></i>
                </div>
                Crashify
            </a>

            <nav class="nav-menu">
                <a href="#" class="nav-item active">Home</a>
                <a href="#sportsbook" class="nav-item">Sportsbook</a>
                <a href="#live" class="nav-item">Live Betting</a>
                <a href="#casino" class="nav-item">Casino</a>
                <a href="#esports" class="nav-item">eSports</a>
            </nav>

            <div class="wallet-info">
                <div class="balance-display">
                    <div class="balance-item">
                        <div class="balance-label">Main Wallet</div>
                        <div class="balance-amount">$1,234.56</div>
                    </div>
                    <div class="balance-item">
                        <div class="balance-label">Bonus</div>
                        <div class="balance-amount">$89.12</div>
                    </div>
                </div>

                <div class="header-actions">
                    <button class="btn btn-outline" onclick="openModal('depositModal')">
                        <i class="fas fa-plus"></i>
                        Deposit
                    </button>
                    <button class="btn btn-primary" onclick="openModal('withdrawModal')">
                        <i class="fas fa-minus"></i>
                        Withdraw
                    </button>

                    <div class="notification-icon" onclick="toggleNotifications()">
                        <i class="fas fa-bell"></i>
                        <div class="notification-badge"></div>
                    </div>

                    <div class="language-selector">
                        <div class="language-btn" onclick="toggleLanguages()">
                            <div class="flag-icon" style="background-image: url('data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 60 30%22><rect width=%2260%22 height=%2230%22 fill=%22%23012169%22/><g stroke=%22%23fff%22><g stroke-width=%226%22><path d=%22m0,0 60,30m0-30L0,30%22/></g><g stroke-width=%224%22><path d=%22m0,0 60,30m0-30L0,30%22 stroke=%22%23C8102E%22/></g><path d=%22m30,0v30m-30-15h60%22 stroke=%22%23fff%22 stroke-width=%225%22/><path d=%22m30,0v30m-30-15h60%22 stroke=%22%23C8102E%22 stroke-width=%223%22/></g></svg>')"></div>
                            EN
                            <i class="fas fa-chevron-down"></i>
                        </div>
                    </div>

                    <div class="theme-selector" onclick="toggleThemes()">
                        <div class="theme-dot active" style="background: #00d4ff;" data-theme="blue"></div>
                        <div class="theme-dot" style="background: #8b5cf6;" data-theme="purple"></div>
                        <div class="theme-dot" style="background: #10b981;" data-theme="green"></div>
                        <div class="theme-dot" style="background: #f59e0b;" data-theme="orange"></div>
                        <div class="theme-dot" style="background: #ef4444;" data-theme="red"></div>
                    </div>

                    <div class="user-menu">
                        <button class="btn btn-outline" onclick="openModal('loginModal')">
                            <i class="fas fa-user"></i>
                            Login
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Hero Section -->
        <section class="hero">
            <div class="hero-content">
                <h1>Welcome to Crashify</h1>
                <p>The ultimate crypto betting platform with live sports, casino games, and instant payouts. Experience the future of online betting with our cutting-edge technology and unmatched security.</p>
                
                <div class="hero-actions">
                    <button class="btn btn-primary" onclick="openModal('registerModal')">
                        <i class="fas fa-rocket"></i>
                        Start Betting Now
                    </button>
                    <button class="btn btn-outline" onclick="scrollToSection('features')">
                        <i class="fas fa-play"></i>
                        Watch Demo
                    </button>
                </div>

                <div class="hero-stats">
                    <div class="stat-item fade-in">
                        <div class="stat-number">50K+</div>
                        <div class="stat-label">Active Users</div>
                    </div>
                    <div class="stat-item fade-in">
                        <div class="stat-number">$2M+</div>
                        <div class="stat-label">Daily Volume</div>
                    </div>
                    <div class="stat-item fade-in">
                        <div class="stat-number">99.9%</div>
                        <div class="stat-label">Uptime</div>
                    </div>
                    <div class="stat-item fade-in">
                        <div class="stat-number">24/7</div>
                        <div class="stat-label">Support</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Quick Access -->
        <section class="quick-access" id="features">
            <div class="container">
                <h2 class="section-title">Quick Access</h2>
                <p class="section-subtitle">Jump into your favorite betting categories instantly</p>
                
                <div class="quick-grid">
                    <div class="quick-card slide-in" onclick="navigateTo('sportsbook')">
                        <div class="quick-icon">
                            <i class="fas fa-futbol"></i>
                        </div>
                        <h3 class="quick-title">Sports Betting</h3>
                        <p class="quick-description">Bet on your favorite sports with the best odds and live updates</p>
                    </div>

                    <div class="quick-card slide-in" onclick="navigateTo('live-betting')">
                        <div class="quick-icon">
                            <i class="fas fa-broadcast-tower"></i>
                        </div>
                        <h3 class="quick-title">Live Betting</h3>
                        <p class="quick-description">Real-time betting with dynamic odds and instant settlements</p>
                    </div>

                    <div class="quick-card slide-in" onclick="navigateTo('casino')">
                        <div class="quick-icon">
                            <i class="fas fa-dice"></i>
                        </div>
                        <h3 class="quick-title">Casino Games</h3>
                        <p class="quick-description">Slots, table games, and live dealers for the ultimate casino experience</p>
                    </div>

                    <div class="quick-card slide-in" onclick="navigateTo('esports')">
                        <div class="quick-icon">
                            <i class="fas fa-gamepad"></i>
                        </div>
                        <h3 class="quick-title">eSports</h3>
                        <p class="quick-description">Bet on professional gaming tournaments and matches</p>
                    </div>

                    <div class="quick-card slide-in" onclick="navigateTo('wallet')">
                        <div class="quick-icon">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <h3 class="quick-title">Crypto Wallet</h3>
                        <p class="quick-description">Secure deposits and withdrawals with 20+ cryptocurrencies</p>
                    </div>

                    <div class="quick-card slide-in" onclick="navigateTo('bonuses')">
                        <div class="quick-icon">
                            <i class="fas fa-gift"></i>
                        </div>
                        <h3 class="quick-title">Bonuses</h3>
                        <p class="quick-description">Exclusive promotions, free bets, and loyalty rewards</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Live Events -->
        <section class="live-events">
            <div class="container">
                <h2 class="section-title">Live Events</h2>
                <p class="section-subtitle">Bet on live matches with real-time odds</p>
                
                <div class="events-grid" id="liveEvents">
                    <!-- Live events will be loaded here -->
                </div>
            </div>
        </section>

        <!-- Crypto Support -->
        <section class="crypto-section">
            <div class="container">
                <h2 class="section-title">Supported Cryptocurrencies</h2>
                <p class="section-subtitle">Deposit and withdraw with your favorite crypto</p>
                
                <div class="crypto-grid">
                    <div class="crypto-item">
                        <div class="crypto-icon">₿</div>
                        <div class="crypto-name">Bitcoin</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">Ξ</div>
                        <div class="crypto-name">Ethereum</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">₮</div>
                        <div class="crypto-name">USDT</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">Ł</div>
                        <div class="crypto-name">Litecoin</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">◊</div>
                        <div class="crypto-name">Dogecoin</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">₳</div>
                        <div class="crypto-name">Cardano</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">⟠</div>
                        <div class="crypto-name">Polygon</div>
                    </div>
                    <div class="crypto-item">
                        <div class="crypto-icon">◎</div>
                        <div class="crypto-name">Solana</div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-content">
            <div class="footer-section">
                <h3>Crashify</h3>
                <p>The most trusted crypto betting platform with instant payouts and 24/7 support.</p>
                <div class="social-links">
                    <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-telegram"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-discord"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                </div>
            </div>

            <div class="footer-section">
                <h3>Sports</h3>
                <ul class="footer-links">
                    <li><a href="#">Football</a></li>
                    <li><a href="#">Basketball</a></li>
                    <li><a href="#">Tennis</a></li>
                    <li><a href="#">eSports</a></li>
                    <li><a href="#">Live Betting</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h3>Casino</h3>
                <ul class="footer-links">
                    <li><a href="#">Slots</a></li>
                    <li><a href="#">Table Games</a></li>
                    <li><a href="#">Live Casino</a></li>
                    <li><a href="#">Crash Games</a></li>
                    <li><a href="#">Tournaments</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h3>Support</h3>
                <ul class="footer-links">
                    <li><a href="#">Help Center</a></li>
                    <li><a href="#">Live Chat</a></li>
                    <li><a href="#">Contact Us</a></li>
                    <li><a href="#">Responsible Gaming</a></li>
                    <li><a href="#">Terms & Conditions</a></li>
                </ul>
            </div>
        </div>

        <div class="footer-bottom">
            <p>&copy; 2024 Crashify. All rights reserved. | Licensed and regulated | 18+ only</p>
        </div>
    </footer>

    <!-- Floating Action Button -->
    <div class="fab" onclick="openSupport()">
        <i class="fas fa-comments"></i>
    </div>

    <!-- Modals -->
    <!-- Login Modal -->
    <div class="modal" id="loginModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Login to Crashify</h3>
                <button class="modal-close" onclick="closeModal('loginModal')">&times;</button>
            </div>
            <form id="loginForm">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Email or Username</label>
                    <input type="text" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Password</label>
                    <input type="password" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%; margin-bottom: 15px;">
                    <i class="fas fa-sign-in-alt"></i>
                    Login
                </button>
                <p style="text-align: center; color: var(--text-secondary);">
                    Don't have an account? <a href="#" onclick="closeModal('loginModal'); openModal('registerModal')" style="color: var(--primary);">Register here</a>
                </p>
            </form>
        </div>
    </div>

    <!-- Register Modal -->
    <div class="modal" id="registerModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Join Crashify</h3>
                <button class="modal-close" onclick="closeModal('registerModal')">&times;</button>
            </div>
            <form id="registerForm">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Username</label>
                    <input type="text" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Email</label>
                    <input type="email" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Password</label>
                    <input type="password" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%; margin-bottom: 15px;">
                    <i class="fas fa-user-plus"></i>
                    Create Account
                </button>
                <p style="text-align: center; color: var(--text-secondary);">
                    Already have an account? <a href="#" onclick="closeModal('registerModal'); openModal('loginModal')" style="color: var(--primary);">Login here</a>
                </p>
            </form>
        </div>
    </div>

    <!-- Deposit Modal -->
    <div class="modal" id="depositModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Deposit Crypto</h3>
                <button class="modal-close" onclick="closeModal('depositModal')">&times;</button>
            </div>
            <div id="depositContent">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Select Cryptocurrency</label>
                    <select style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" onchange="generateDepositAddress(this.value)">
                        <option value="">Choose crypto...</option>
                        <option value="BTC">Bitcoin (BTC)</option>
                        <option value="ETH">Ethereum (ETH)</option>
                        <option value="USDT">Tether (USDT)</option>
                        <option value="LTC">Litecoin (LTC)</option>
                    </select>
                </div>
                <div id="depositAddress" style="display: none;">
                    <div style="text-align: center; padding: 20px; background: var(--accent); border-radius: 12px; margin-bottom: 20px;">
                        <div style="width: 150px; height: 150px; background: white; margin: 0 auto 15px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                            <div id="qrCode" style="font-size: 12px; color: #333;">QR Code</div>
                        </div>
                        <div style="word-break: break-all; font-family: monospace; background: var(--surface); padding: 10px; border-radius: 6px; margin-bottom: 10px;" id="walletAddress">
                            Address will appear here
                        </div>
                        <button class="btn btn-outline" onclick="copyAddress()">
                            <i class="fas fa-copy"></i>
                            Copy Address
                        </button>
                    </div>
                    <div style="background: rgba(255, 193, 7, 0.1); border: 1px solid #ffc107; border-radius: 8px; padding: 15px; color: #ffc107;">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Important:</strong> Only send the selected cryptocurrency to this address. Sending other coins may result in permanent loss.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Withdraw Modal -->
    <div class="modal" id="withdrawModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Withdraw Crypto</h3>
                <button class="modal-close" onclick="closeModal('withdrawModal')">&times;</button>
            </div>
            <form id="withdrawForm">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Cryptocurrency</label>
                    <select style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" required>
                        <option value="">Choose crypto...</option>
                        <option value="BTC">Bitcoin (BTC)</option>
                        <option value="ETH">Ethereum (ETH)</option>
                        <option value="USDT">Tether (USDT)</option>
                        <option value="LTC">Litecoin (LTC)</option>
                    </select>
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Wallet Address</label>
                    <input type="text" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text); font-family: monospace;" placeholder="Enter destination address" required>
                </div>
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; color: var(--text-secondary);">Amount</label>
                    <input type="number" step="0.00000001" style="width: 100%; padding: 12px; border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; background: var(--accent); color: var(--text);" placeholder="0.00000000" required>
                </div>
                <div style="background: rgba(220, 38, 38, 0.1); border: 1px solid #dc2626; border-radius: 8px; padding: 15px; color: #dc2626; margin-bottom: 20px;">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>Warning:</strong> Double-check the address. Cryptocurrency transactions are irreversible.
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    <i class="fas fa-paper-plane"></i>
                    Submit Withdrawal
                </button>
            </form>
        </div>
    </div>

    <script>
        // Global variables
        let currentTheme = 'blue';
        let currentLanguage = 'en';
        let liveEventsInterval;

        // Initialize the application
        document.addEventListener('DOMContentLoaded', function() {
            initializeApp();
            loadLiveEvents();
            startLiveUpdates();
        });

        function initializeApp() {
            // Load saved theme
            const savedTheme = localStorage.getItem('crashify_theme') || 'blue';
            changeTheme(savedTheme);

            // Load saved language
            const savedLanguage = localStorage.getItem('crashify_language') || 'en';
            changeLanguage(savedLanguage);

            // Initialize event listeners
            setupEventListeners();
        }

        function setupEventListeners() {
            // Theme selector
            document.querySelectorAll('.theme-dot').forEach(dot => {
                dot.addEventListener('click', function() {
                    const theme = this.dataset.theme;
                    changeTheme(theme);
                });
            });

            // Form submissions
            document.getElementById('loginForm').addEventListener('submit', handleLogin);
            document.getElementById('registerForm').addEventListener('submit', handleRegister);
            document.getElementById('withdrawForm').addEventListener('submit', handleWithdraw);

            // Close modals on outside click
            document.querySelectorAll('.modal').forEach(modal => {
                modal.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeModal(this.id);
                    }
                });
            });
        }

        // Theme Management
        function changeTheme(theme) {
            document.body.className = `theme-${theme}`;
            
            // Update active theme dot
            document.querySelectorAll('.theme-dot').forEach(dot => {
                dot.classList.remove('active');
                if (dot.dataset.theme === theme) {
                    dot.classList.add('active');
                }
            });

            currentTheme = theme;
            localStorage.setItem('crashify_theme', theme);
        }

        function toggleThemes() {
            // This could open a theme selector dropdown
            console.log('Theme selector clicked');
        }

        // Language Management
        function changeLanguage(lang) {
            currentLanguage = lang;
            localStorage.setItem('crashify_language', lang);
            // Here you would typically load language strings and update the UI
            console.log(`Language changed to: ${lang}`);
        }

        function toggleLanguages() {
            // This could open a language selector dropdown
            console.log('Language selector clicked');
        }

        // Modal Management
        function openModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                modal.classList.add('active');
                document.body.style.overflow = 'hidden';
            }
        }

        function closeModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                modal.classList.remove('active');
                document.body.style.overflow = 'auto';
            }
        }

        // Navigation
        function navigateTo(page) {
            console.log(`Navigating to: ${page}`);
            // Here you would implement actual navigation
            // For demo purposes, we'll just show an alert
            alert(`Navigating to ${page} page...`);
        }

        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }

        // Live Events
        function loadLiveEvents() {
            const eventsContainer = document.getElementById('liveEvents');
            const sampleEvents = [
                {
                    league: 'Premier League',
                    team1: { name: 'Manchester United', logo: '🔴' },
                    team2: { name: 'Liverpool', logo: '🔴' },
                    odds: { home: '2.10', draw: '3.40', away: '3.20' },
                    time: '45\' + 2',
                    live: true
                },
                {
                    league: 'La Liga',
                    team1: { name: 'Real Madrid', logo: '⚪' },
                    team2: { name: 'Barcelona', logo: '🔵' },
                    odds: { home: '1.95', draw: '3.60', away: '3.80' },
                    time: '23\'',
                    live: true
                },
                {
                    league: 'NBA',
                    team1: { name: 'Lakers', logo: '🟡' },
                    team2: { name: 'Warriors', logo: '🔵' },
                    odds: { home: '1.85', draw: null, away: '1.95' },
                    time: 'Q2 8:45',
                    live: true
                }
            ];

            eventsContainer.innerHTML = sampleEvents.map(event => `
                <div class="event-card fade-in">
                    <div class="event-header">
                        <div class="event-league">${event.league}</div>
                        ${event.live ? '<div class="live-indicator"><div class="live-dot"></div>LIVE</div>' : ''}
                    </div>
                    <div class="event-teams">
                        <div class="team">
                            <div class="team-logo">${event.team1.logo}</div>
                            <div class="team-name">${event.team1.name}</div>
                        </div>
                        <div class="vs-separator">${event.time}</div>
                        <div class="team">
                            <div class="team-logo">${event.team2.logo}</div>
                            <div class="team-name">${event.team2.name}</div>
                        </div>
                    </div>
                    <div class="event-odds">
                        <div class="odd-btn" onclick="addToBetSlip('${event.team1.name}', '${event.odds.home}')">
                            <div class="odd-label">1</div>
                            <div class="odd-value">${event.odds.home}</div>
                        </div>
                        ${event.odds.draw ? `
                            <div class="odd-btn" onclick="addToBetSlip('Draw', '${event.odds.draw}')">
                                <div class="odd-label">X</div>
                                <div class="odd-value">${event.odds.draw}</div>
                            </div>
                        ` : '<div></div>'}
                        <div class="odd-btn" onclick="addToBetSlip('${event.team2.name}', '${event.odds.away}')">
                            <div class="odd-label">2</div>
                            <div class="odd-value">${event.odds.away}</div>
                        </div>
                    </div>
                </div>
            `).join('');
        }

        function startLiveUpdates() {
            liveEventsInterval = setInterval(() => {
                // Update odds with small random changes
                document.querySelectorAll('.odd-value').forEach(odd => {
                    const currentOdd = parseFloat(odd.textContent);
                    const change = (Math.random() - 0.5) * 0.1;
                    const newOdd = Math.max(1.01, currentOdd + change);
                    odd.textContent = newOdd.toFixed(2);
                    
                    // Add visual feedback for odds changes
                    odd.style.color = change > 0 ? '#00ff88' : '#ff4444';
                    setTimeout(() => {
                        odd.style.color = '';
                    }, 1000);
                });
            }, 3000);
        }

        // Betting Functions
        function addToBetSlip(selection, odds) {
            console.log(`Added to bet slip: ${selection} @ ${odds}`);
            // Here you would add the selection to the bet slip
            showNotification(`Added ${selection} @ ${odds} to bet slip`, 'success');
        }

        // Wallet Functions
        function generateDepositAddress(crypto) {
            if (!crypto) {
                document.getElementById('depositAddress').style.display = 'none';
                return;
            }

            // Generate a sample address (in real app, this would come from your backend)
            const sampleAddresses = {
                'BTC': '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                'ETH': '0x742d35Cc6634C0532925a3b8D4C0C8b3C2e1e3e3',
                'USDT': '0x742d35Cc6634C0532925a3b8D4C0C8b3C2e1e3e3',
                'LTC': 'LTC1qw508d6qejxtdg4y5r3zarvary0c5xw7k3w508d6qejxtdg4y5r3zarvary0c5xw7k'
            };

            const address = sampleAddresses[crypto];
            document.getElementById('walletAddress').textContent = address;
            document.getElementById('qrCode').textContent = `QR for ${crypto}`;
            document.getElementById('depositAddress').style.display = 'block';
        }

        function copyAddress() {
            const address = document.getElementById('walletAddress').textContent;
            navigator.clipboard.writeText(address).then(() => {
                showNotification('Address copied to clipboard!', 'success');
            });
        }

        // Form Handlers
        function handleLogin(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            console.log('Login attempt:', Object.fromEntries(formData));
            
            // Simulate login process
            showNotification('Logging in...', 'info');
            setTimeout(() => {
                showNotification('Login successful!', 'success');
                closeModal('loginModal');
                // Update UI to show logged in state
                updateUserInterface(true);
            }, 2000);
        }

        function handleRegister(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            console.log('Registration attempt:', Object.fromEntries(formData));
            
            // Simulate registration process
            showNotification('Creating account...', 'info');
            setTimeout(() => {
                showNotification('Account created successfully!', 'success');
                closeModal('registerModal');
                updateUserInterface(true);
            }, 2000);
        }

        function handleWithdraw(e) {
            e.preventDefault();
            const formData = new FormData(e.target);
            console.log('Withdrawal request:', Object.fromEntries(formData));
            
            // Simulate withdrawal process
            showNotification('Processing withdrawal...', 'info');
            setTimeout(() => {
                showNotification('Withdrawal submitted for processing!', 'success');
                closeModal('withdrawModal');
            }, 2000);
        }

        // UI Updates
        function updateUserInterface(isLoggedIn) {
            const userMenu = document.querySelector('.user-menu');
            if (isLoggedIn) {
                userMenu.innerHTML = `
                    <div class="user-profile" onclick="toggleUserMenu()">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <span>Player123</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                `;
            }
        }

        // Notifications
        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `notification notification-${type}`;
            notification.style.cssText = `
                position: fixed;
                top: 90px;
                right: 20px;
                background: var(--surface);
                color: var(--text);
                padding: 15px 20px;
                border-radius: 8px;
                border-left: 4px solid var(--${type === 'success' ? 'success' : type === 'error' ? 'error' : 'primary'});
                box-shadow: 0 10px 25px rgba(0,0,0,0.3);
                z-index: 3000;
                animation: slideIn 0.3s ease;
                max-width: 300px;
            `;
            notification.textContent = message;
            
            document.body.appendChild(notification);
            
            setTimeout(() => {
                notification.style.animation = 'slideOut 0.3s ease forwards';
                setTimeout(() => {
                    document.body.removeChild(notification);
                }, 300);
            }, 3000);
        }

        function toggleNotifications() {
            console.log('Notifications clicked');
            // Here you would show a notifications dropdown
        }

        // Support Functions
        function openSupport() {
            console.log('Opening support chat');
            // Here you would open the support chat widget
            showNotification('Support chat opening...', 'info');
        }

        // Utility Functions
        function toggleUserMenu() {
            console.log('User menu clicked');
            // Here you would show user menu dropdown
        }

        // Cleanup
        window.addEventListener('beforeunload', function() {
            if (liveEventsInterval) {
                clearInterval(liveEventsInterval);
            }
        });

        // Add some CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideOut {
                to {
                    transform: translateX(100%);
                    opacity: 0;
                }
            }
            
            .notification {
                animation: slideIn 0.3s ease;
            }
        `;
        document.head.appendChild(style);
    </script>
<script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'98040a9f8614a0cd',t:'MTc1ODA2NDI3MS4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script></body>
</html>
