<?php
// pages/responsible-gambling.php - Responsible Gambling Page
// صفحه مسئولیت اجتماعی

require_once '../includes/functions.php';

$page_title = 'مسئولیت اجتماعی';
$current_page = 'responsible-gambling';

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header text-center">
                <h1><i class="fas fa-shield-alt"></i> مسئولیت اجتماعی</h1>
                <p class="text-muted">تعهد ما به بازی مسئولانه و حمایت از کاربران</p>
            </div>
        </div>
    </div>
    
    <!-- Introduction -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-body">
                    <div class="intro-content text-center">
                        <div class="intro-icon mb-4">
                            <i class="fas fa-heart fa-3x text-danger"></i>
                        </div>
                        <h3>تعهد ما به شما</h3>
                        <p class="lead">
                            در Crashify، ما متعهد به ارائه محیطی امن و مسئولانه برای تمام کاربران هستیم. 
                            بازی باید سرگرمی باشد، نه مشکل.
                        </p>
                        <div class="stats-row">
                            <div class="stat-item">
                                <div class="stat-number">24/7</div>
                                <div class="stat-label">پشتیبانی</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">100%</div>
                                <div class="stat-label">محرمانگی</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">0</div>
                                <div class="stat-label">تبعیض</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Warning Signs -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-exclamation-triangle text-warning"></i> علائم هشدار</h4>
                    <p class="mb-0">اگر این علائم را در خود مشاهده می‌کنید، ممکن است نیاز به کمک داشته باشید:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-clock text-danger"></i> علائم زمانی</h6>
                                <ul class="warning-list">
                                    <li>صرف زمان بیش از حد برای بازی</li>
                                    <li>فراموش کردن تعهدات مهم</li>
                                    <li>بازی در ساعات نامناسب</li>
                                    <li>عدم کنترل زمان بازی</li>
                                    <li>دروغ گفتن درباره زمان بازی</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-dollar-sign text-danger"></i> علائم مالی</h6>
                                <ul class="warning-list">
                                    <li>بازی با پول مورد نیاز برای زندگی</li>
                                    <li>قرض گرفتن برای بازی</li>
                                    <li>تلاش برای جبران ضررها</li>
                                    <li>افزایش مداوم مبلغ شرط‌ها</li>
                                    <li>پنهان کردن ضررهای مالی</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-brain text-danger"></i> علائم روحی</h6>
                                <ul class="warning-list">
                                    <li>اضطراب و استرس مداوم</li>
                                    <li>تغییرات خلقی شدید</li>
                                    <li>احساس گناه و شرم</li>
                                    <li>افسردگی و ناامیدی</li>
                                    <li>عدم تمرکز در کارهای روزمره</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-users text-danger"></i> علائم اجتماعی</h6>
                                <ul class="warning-list">
                                    <li>دوری از خانواده و دوستان</li>
                                    <li>کاهش فعالیت‌های اجتماعی</li>
                                    <li>مشکلات در روابط</li>
                                    <li>انزوا و تنهایی</li>
                                    <li>دروغ گفتن به نزدیکان</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Self-Assessment Tool -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-clipboard-check"></i> ابزار خودارزیابی</h4>
                    <p class="mb-0">پاسخ صادقانه به این سوالات می‌تواند به شما کمک کند:</p>
                </div>
                <div class="card-body">
                    <form id="selfAssessmentForm" class="assessment-form">
                        <div class="assessment-questions">
                            <div class="question-item">
                                <p class="question-text">آیا بیش از آنچه قصد داشتید، پول خرج بازی می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q1" value="0"> هرگز</label>
                                    <label><input type="radio" name="q1" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q1" value="2"> اغلب</label>
                                    <label><input type="radio" name="q1" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا نیاز به افزایش مبلغ شرط برای همان هیجان احساس می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q2" value="0"> هرگز</label>
                                    <label><input type="radio" name="q2" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q2" value="2"> اغلب</label>
                                    <label><input type="radio" name="q2" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا سعی کرده‌اید بازی را کنترل، کاهش یا متوقف کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q3" value="0"> هرگز</label>
                                    <label><input type="radio" name="q3" value="1"> یک بار</label>
                                    <label><input type="radio" name="q3" value="2"> چند بار</label>
                                    <label><input type="radio" name="q3" value="3"> بارها</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا هنگام کاهش یا توقف بازی، بی‌قراری یا تحریک‌پذیری احساس می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q4" value="0"> هرگز</label>
                                    <label><input type="radio" name="q4" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q4" value="2"> اغلب</label>
                                    <label><input type="radio" name="q4" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا از بازی برای فرار از مشکلات یا احساسات منفی استفاده می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q5" value="0"> هرگز</label>
                                    <label><input type="radio" name="q5" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q5" value="2"> اغلب</label>
                                    <label><input type="radio" name="q5" value="3"> همیشه</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-primary" onclick="calculateAssessment()">
                                <i class="fas fa-calculator"></i> محاسبه نتیجه
                            </button>
                        </div>
                        
                        <div id="assessmentResult" class="assessment-result mt-4" style="display: none;">
                            <div class="result-content">
                                <h5 class="result-title"></h5>
                                <p class="result-description"></p>
                                <div class="result-actions"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Control Tools -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-tools"></i> ابزارهای کنترل</h4>
                    <p class="mb-0">ابزارهایی که می‌توانید برای کنترل بازی خود استفاده کنید:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <h6>محدودیت واریز</h6>
                                <p>تعیین حداکثر مبلغ واریز روزانه، هفتگی یا ماهانه</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <h6>محدودیت ضرر</h6>
                                <p>تعیین حداکثر مبلغ ضرر قابل قبول در بازه زمانی مشخص</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <h6>محدودیت زمان</h6>
                                <p>تعیین حداکثر زمان بازی در روز یا هفته</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-pause"></i>
                                </div>
                                <h6>استراحت موقت</h6>
                                <p>مسدود کردن موقت حساب برای مدت زمان مشخص</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#timeout" class="btn btn-sm btn-outline-warning">فعال‌سازی</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-ban"></i>
                                </div>
                                <h6>خودمحدودسازی</h6>
                                <p>مسدود کردن دائمی حساب کاربری</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#self-exclusion" class="btn btn-sm btn-outline-danger">درخواست</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-bell-slash"></i>
                                </div>
                                <h6>محدودیت تبلیغات</h6>
                                <p>عدم دریافت ایمیل‌ها و پیام‌های تبلیغاتی</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#notifications" class="btn btn-sm btn-outline-secondary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <h6>گزارش فعالیت</h6>
                                <p>مشاهده آمار کامل بازی و تراکنش‌ها</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/bet-history.php" class="btn btn-sm btn-outline-info">مشاهده</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-user-friends"></i>
                                </div>
                                <h6>کمک خانواده</h6>
                                <p>امکان نظارت خانواده بر فعالیت‌های بازی</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/support.php" class="btn btn-sm btn-outline-success">درخواست</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Help Resources -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-life-ring"></i> منابع کمک</h4>
                    <p class="mb-0">اگر احساس می‌کنید به کمک نیاز دارید، این منابع در دسترس شما هستند:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-phone text-success"></i>
                                    <h6>خط کمک ملی</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>تلفن:</strong> 1-800-522-4700</p>
                                    <p><strong>ساعات کاری:</strong> 24 ساعته، 7 روز هفته</p>
                                    <p>مشاوره رایگان و محرمانه</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-comments text-primary"></i>
                                    <h6>چت آنلاین</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>وب‌سایت:</strong> www.ncpgambling.org</p>
                                    <p><strong>دسترسی:</strong> 24 ساعته</p>
                                    <p>گفتگوی زنده با مشاوران متخصص</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-users text-info"></i>
                                    <h6>گروه‌های حمایتی</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>قمارچیان گمنام:</strong> www.gamblersanonymous.org</p>
                                    <p><strong>جلسات:</strong> حضوری و آنلاین</p>
                                    <p>حمایت همتایان و تجربه مشترک</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-heart text-danger"></i>
                                    <h6>حمایت خانواده</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>Gam-Anon:</strong> www.gam-anon.org</p>
                                    <p><strong>هدف:</strong> کمک به خانواده‌ها</p>
                                    <p>راهنمایی برای نزدیکان قماربازان</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="emergency-help">
                        <div class="alert alert-danger">
                            <h6><i class="fas fa-exclamation-triangle"></i> در شرایط اضطراری</h6>
                            <p class="mb-2">اگر به خود یا دیگران آسیب رساندن فکر می‌کنید:</p>
                            <ul class="mb-2">
                                <li>فوراً با اورژانس تماس بگیرید: 911</li>
                                <li>خط کمک خودکشی: 988</li>
                                <li>به نزدیک‌ترین بیمارستان مراجعه کنید</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tips for Responsible Gaming -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-lightbulb"></i> نکات بازی مسئولانه</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="tips-section">
                                <h6><i class="fas fa-check-circle text-success"></i> کارهای مثبت</h6>
                                <ul class="tips-list positive">
                                    <li>بودجه مشخصی برای بازی تعیین کنید</li>
                                    <li>بازی را به عنوان سرگرمی ببینید</li>
                                    <li>زمان مشخصی برای بازی اختصاص دهید</li>
                                    <li>استراحت منظم داشته باشید</li>
                                    <li>با دوستان و خانواده وقت بگذرانید</li>
                                    <li>فعالیت‌های دیگری نیز داشته باشید</li>
                                    <li>قوانین بازی را بیاموزید</li>
                                    <li>احساسات خود را کنترل کنید</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="tips-section">
                                <h6><i class="fas fa-times-circle text-danger"></i> کارهای منفی</h6>
                                <ul class="tips-list negative">
                                    <li>با پول مورد نیاز زندگی بازی نکنید</li>
                                    <li>سعی در جبران ضررها نکنید</li>
                                    <li>تحت تأثیر الکل یا مواد بازی نکنید</li>
                                    <li>هنگام ناراحتی یا استرس بازی نکنید</li>
                                    <li>از بازی به عنوان راه حل مشکلات استفاده نکنید</li>
                                    <li>قرض نگیرید تا بازی کنید</li>
                                    <li>درباره بازی دروغ نگویید</li>
                                    <li>بازی را از سایر فعالیت‌ها مهم‌تر ندانید</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Contact Support -->
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-body text-center">
                    <div class="support-contact">
                        <i class="fas fa-headset fa-3x text-primary mb-3"></i>
                        <h4>نیاز به کمک دارید؟</h4>
                        <p class="lead">تیم پشتیبانی ما آماده کمک به شما است</p>
                        <div class="contact-options">
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/support.php" class="btn btn-primary btn-lg">
                                <i class="fas fa-envelope"></i> تماس با پشتیبانی
                            </a>
                            <a href="tel:+1-800-522-4700" class="btn btn-outline-primary btn-lg">
                                <i class="fas fa-phone"></i> تماس فوری
                            </a>
                        </div>
                        <p class="mt-3 text-muted">
                            <small>تمام مکالمات و پیام‌ها کاملاً محرمانه هستند</small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 3rem;
    padding: 2rem 0;
}

.intro-content {
    padding: 2rem;
}

.intro-icon {
    margin-bottom: 2rem;
}

.stats-row {
    display: flex;
    justify-content: center;
    gap: 3rem;
    margin-top: 2rem;
}

.stat-item {
    text-align: center;
}

.stat-number {
    font-size: 2rem;
    font-weight: bold;
    color: #007bff;
}

.stat-label {
    font-size: 0.9rem;
    color: #6c757d;
}

.warning-signs h6 {
    color: #495057;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
}

.warning-signs h6 i {
    margin-right: 0.5rem;
}

.warning-list {
    list-style: none;
    padding: 0;
}

.warning-list li {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f8f9fa;
    position: relative;
    padding-left: 1.5rem;
}

.warning-list li:before {
    content: '⚠️';
    position: absolute;
    left: 0;
    top: 0.5rem;
}

.assessment-form {
    max-width: 100%;
}

.question-item {
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.question-text {
    font-weight: 500;
    margin-bottom: 1rem;
    color: #495057;
}

.question-options {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.question-options label {
    display: flex;
    align-items: center;
    cursor: pointer;
    padding: 0.5rem 1rem;
    background: white;
    border: 2px solid #dee2e6;
    border-radius: 25px;
    transition: all 0.3s;
}

.question-options label:hover {
    border-color: #007bff;
}

.question-options label input {
    margin-right: 0.5rem;
}

.question-options label input:checked + label,
.question-options label:has(input:checked) {
    background: #007bff;
    color: white;
    border-color: #007bff;
}

.assessment-result {
    padding: 2rem;
    border-radius: 10px;
    text-align: center;
}

.assessment-result.low-risk {
    background: #d4edda;
    border: 2px solid #28a745;
}

.assessment-result.medium-risk {
    background: #fff3cd;
    border: 2px solid #ffc107;
}

.assessment-result.high-risk {
    background: #f8d7da;
    border: 2px solid #dc3545;
}

.control-tool {
    text-align: center;
    padding: 2rem 1rem;
    background: #f8f9fa;
    border-radius: 15px;
    height: 100%;
    transition: transform 0.3s, box-shadow 0.3s;
}

.control-tool:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.tool-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
}

.control-tool h6 {
    color: #495057;
    margin-bottom: 1rem;
    font-weight: 600;
}

.control-tool p {
    color: #6c757d;
    font-size: 0.9rem;
    margin-bottom: 1.5rem;
}

.help-resource {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 10px;
    height: 100%;
}

.resource-header {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
}

.resource-header i {
    font-size: 1.5rem;
    margin-right: 0.75rem;
}

.resource-header h6 {
    margin: 0;
    color: #495057;
    font-weight: 600;
}

.resource-content p {
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.resource-content strong {
    color: #495057;
}

.emergency-help {
    margin-top: 2rem;
}

.emergency-help .alert {
    border-left: 5px solid #dc3545;
}

.tips-section h6 {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
}

.tips-section h6 i {
    margin-right: 0.5rem;
}

.tips-list {
    list-style: none;
    padding: 0;
}

.tips-list li {
    padding: 0.75rem 0;
    border-bottom: 1px solid #f8f9fa;
    position: relative;
    padding-left: 2rem;
}

.tips-list.positive li:before {
    content: '✓';
    position: absolute;
    left: 0;
    top: 0.75rem;
    color: #28a745;
    font-weight: bold;
    font-size: 1.1rem;
}

.tips-list.negative li:before {
    content: '✗';
    position: absolute;
    left: 0;
    top: 0.75rem;
    color: #dc3545;
    font-weight: bold;
    font-size: 1.1rem;
}

.support-contact {
    padding: 2rem;
}

.contact-options {
    margin: 2rem 0;
}

.contact-options .btn {
    margin: 0 0.5rem 1rem;
}

@media (max-width: 768px) {
    .stats-row {
        flex-direction: column;
        gap: 1rem;
    }
    
    .question-options {
        flex-direction: column;
    }
    
    .question-options label {
        justify-content: center;
    }
    
    .contact-options .btn {
        display: block;
        margin: 0.5rem 0;
    }
}
</style>

<script>
function calculateAssessment() {
    const form = document.getElementById('selfAssessmentForm');
    const questions = ['q1', 'q2', 'q3', 'q4', 'q5'];
    let totalScore = 0;
    let answeredQuestions = 0;
    
    questions.forEach(question => {
        const selectedOption = form.querySelector(`input[name="${question}"]:checked`);
        if (selectedOption) {
            totalScore += parseInt(selectedOption.value);
            answeredQuestions++;
        }
    });
    
    if (answeredQuestions < questions.length) {
        alert('لطفاً به تمام سوالات پاسخ دهید');
        return;
    }
    
    const resultDiv = document.getElementById('assessmentResult');
    const titleElement = resultDiv.querySelector('.result-title');
    const descriptionElement = resultDiv.querySelector('.result-description');
    const actionsElement = resultDiv.querySelector('.result-actions');
    
    let riskLevel, title, description, actions, className;
    
    if (totalScore <= 3) {
        riskLevel = 'low';
        className = 'low-risk';
        title = 'ریسک پایین';
        description = 'الگوی بازی شما نسبتاً سالم به نظر می‌رسد. همچنان مراقب باشید و از ابزارهای کنترل استفاده کنید.';
        actions = `
            <div class="mt-3">
                <a href="#control-tools" class="btn btn-success">مشاهده ابزارهای کنترل</a>
            </div>
        `;
    } else if (totalScore <= 7) {
        riskLevel = 'medium';
        className = 'medium-risk';
        title = 'ریسک متوسط';
        description = 'ممکن است در حال توسعه مشکلات مرتبط با بازی باشید. توصیه می‌شود محدودیت‌هایی برای خود تعیین کنید.';
        actions = `
            <div class="mt-3">
                <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#limits" class="btn btn-warning">تنظیم محدودیت‌ها</a>
                <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/support.php" class="btn btn-outline-primary">درخواست مشاوره</a>
            </div>
        `;
    } else {
        riskLevel = 'high';
        className = 'high-risk';
        title = 'ریسک بالا';
        description = 'نتایج نشان می‌دهد که ممکن است مشکل جدی با بازی داشته باشید. قویاً توصیه می‌شود کمک متخصص بگیرید.';
        actions = `
            <div class="mt-3">
                <a href="tel:+1-800-522-4700" class="btn btn-danger">تماس فوری با خط کمک</a>
                <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/profile.php#self-exclusion" class="btn btn-outline-danger">خودمحدودسازی</a>
            </div>
        `;
    }
    
    resultDiv.className = `assessment-result ${className}`;
    titleElement.textContent = title;
    descriptionElement.textContent = description;
    actionsElement.innerHTML = actions;
    
    resultDiv.style.display = 'block';
    resultDiv.scrollIntoView({ behavior: 'smooth' });
}

// Smooth scrolling for anchor links
document.addEventListener('DOMContentLoaded', function() {
    const links = document.querySelectorAll('a[href^="#"]');
    
    links.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href').substring(1);
            const targetElement = document.getElementById(targetId);
            
            if (targetElement) {
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>

<?php include '../includes/footer.php'; ?>
