<?php
//pages/privacy.php
require_once '../config/config.php';
require_once '../includes/functions.php';

$pageTitle = 'سیاست حریم خصوصی';
$currentLang = getCurrentLanguage();
$translations = getTranslations($currentLang);
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLang; ?>" dir="<?php echo $currentLang == 'fa' || $currentLang == 'ar' ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - Crashify</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/main.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazir', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .privacy-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            margin: 2rem auto;
            max-width: 1200px;
        }
        
        .privacy-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 3rem 2rem;
            border-radius: 20px 20px 0 0;
            text-align: center;
        }
        
        .privacy-header h1 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            font-weight: 700;
        }
        
        .privacy-content {
            padding: 3rem;
        }
        
        .toc-sidebar {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 1.5rem;
            position: sticky;
            top: 2rem;
            max-height: 80vh;
            overflow-y: auto;
        }
        
        .privacy-section {
            margin-bottom: 3rem;
            padding-bottom: 2rem;
            border-bottom: 1px solid #e9ecef;
        }
        
        .privacy-section h2 {
            color: #495057;
            margin-bottom: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .privacy-section h2 i {
            margin-right: 0.75rem;
            color: #007bff;
        }
        
        .info-card {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1.5rem 0;
        }
        
        .info-card.important {
            background: #fff3cd;
            border-color: #ffeaa7;
        }
        
        .contact-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px;
            padding: 3rem;
            text-align: center;
            margin-top: 3rem;
        }
        
        @media (max-width: 768px) {
            .privacy-header {
                padding: 2rem 1rem;
            }
            
            .privacy-content {
                padding: 2rem 1rem;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="privacy-container">
        <div class="privacy-header">
            <h1><i class="fas fa-user-shield"></i> <?php echo $translations['legal_privacy_title']; ?></h1>
            <p><?php echo $translations['footer_privacy']; ?></p>
            <div class="last-updated">
                <i class="fas fa-calendar-alt"></i>
                <?php echo $translations['time_now']; ?>: <?php echo date('Y/m/d'); ?>
            </div>
        </div>
        
        <div class="privacy-content">
            <div class="row">
                <div class="col-lg-3">
                    <div class="toc-sidebar">
                        <h5><i class="fas fa-list"></i> <?php echo $translations['nav_home']; ?></h5>
                        <ul class="list-unstyled">
                            <li><a href="#introduction" class="text-decoration-none"><?php echo $translations['about']; ?></a></li>
                            <li><a href="#data-collection" class="text-decoration-none"><?php echo $translations['profile_personal_info']; ?></a></li>
                            <li><a href="#data-usage" class="text-decoration-none"><?php echo $translations['profile_security']; ?></a></li>
                            <li><a href="#contact" class="text-decoration-none"><?php echo $translations['contact']; ?></a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-9">
                    <section id="introduction" class="privacy-section">
                        <h2><i class="fas fa-info-circle"></i> <?php echo $translations['about']; ?></h2>
                        <p class="lead">
                            در Crashify، حفظ حریم خصوصی شما برای ما بسیار مهم است. این سیاست حریم خصوصی 
                            توضیح می‌دهد که چگونه اطلاعات شخصی شما را جمع‌آوری، استفاده، و محافظت می‌کنیم.
                        </p>
                        
                        <div class="info-card important">
                            <h5><i class="fas fa-exclamation-circle"></i> <?php echo $translations['info']; ?></h5>
                            <p>
                                با استفاده از خدمات ما، شما با شرایط این سیاست حریم خصوصی موافقت می‌کنید.
                            </p>
                        </div>
                    </section>
                    
                    <section id="data-collection" class="privacy-section">
                        <h2><i class="fas fa-database"></i> <?php echo $translations['profile_personal_info']; ?></h2>
                        <p>ما انواع مختلفی از اطلاعات را برای ارائه بهترین خدمات جمع‌آوری می‌کنیم:</p>
                        
                        <h4><?php echo $translations['auth_email']; ?> و <?php echo $translations['auth_phone']; ?></h4>
                        <ul>
                            <li><?php echo $translations['auth_first_name']; ?> و <?php echo $translations['auth_last_name']; ?></li>
                            <li><?php echo $translations['auth_email']; ?></li>
                            <li><?php echo $translations['auth_phone']; ?></li>
                            <li><?php echo $translations['auth_birth_date']; ?></li>
                            <li><?php echo $translations['auth_address']; ?></li>
                        </ul>
                        
                        <h4><?php echo $translations['wallet_payment_method']; ?></h4>
                        <ul>
                            <li><?php echo $translations['wallet_card']; ?></li>
                            <li><?php echo $translations['wallet_bank']; ?></li>
                            <li><?php echo $translations['wallet_history']; ?></li>
                        </ul>
                    </section>
                    
                    <section id="data-usage" class="privacy-section">
                        <h2><i class="fas fa-cogs"></i> <?php echo $translations['profile_security']; ?></h2>
                        <p>اطلاعات جمع‌آوری شده برای اهداف زیر استفاده می‌شود:</p>
                        
                        <ul>
                            <li>ارائه خدمات <?php echo $translations['nav_casino']; ?> و <?php echo $translations['nav_sports']; ?></li>
                            <li>پردازش <?php echo $translations['wallet_deposit']; ?> و <?php echo $translations['wallet_withdraw']; ?></li>
                            <li><?php echo $translations['profile_verification']; ?> هویت کاربران</li>
                            <li><?php echo $translations['support']; ?> مشتریان</li>
                            <li>حفظ <?php echo $translations['profile_security']; ?> پلتفرم</li>
                        </ul>
                        
                        <div class="info-card">
                            <h5><i class="fas fa-shield-alt"></i> <?php echo $translations['profile_security']; ?></h5>
                            <p>
                                ما از پیشرفته‌ترین تکنولوژی‌های امنیتی برای حفاظت از اطلاعات شما استفاده می‌کنیم.
                            </p>
                        </div>
                    </section>
                    
                    <section id="contact" class="privacy-section">
                        <div class="contact-section">
                            <h3><i class="fas fa-envelope"></i> <?php echo $translations['contact']; ?></h3>
                            <p>اگر سوال یا نگرانی‌ای درباره حریم خصوصی دارید، با ما در تماس باشید:</p>
                            
                            <div class="row mt-4">
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-envelope fa-2x mb-3"></i>
                                        <h6><?php echo $translations['auth_email']; ?></h6>
                                        <a href="mailto:privacy@crashify.com" class="text-white">privacy@crashify.com</a>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-headset fa-2x mb-3"></i>
                                        <h6><?php echo $translations['support']; ?></h6>
                                        <a href="support.php" class="text-white"><?php echo $translations['support_help_center']; ?></a>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-clock fa-2x mb-3"></i>
                                        <h6>ساعات کاری</h6>
                                        <span>24 ساعته، 7 روز هفته</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/main.js"></script>
<script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'98051a07f2cd45dd',t:'MTc1ODA3NTM4OC4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script></body>
</html>