<?php
// pages/terms.php - Terms and Conditions Page
// صفحه قوانین و مقررات

require_once '../includes/functions.php';

$page_title = 'قوانین و مقررات';
$current_page = 'terms';

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header text-center">
                <h1><i class="fas fa-file-contract"></i> قوانین و مقررات</h1>
                <p class="text-muted">شرایط استفاده از خدمات Crashify</p>
                <div class="last-updated">
                    <small class="text-muted">آخرین بروزرسانی: <?php echo date('Y/m/d'); ?></small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Table of Contents -->
    <div class="row mb-4">
        <div class="col-lg-3">
            <div class="card sticky-top">
                <div class="card-header">
                    <h6><i class="fas fa-list"></i> فهرست مطالب</h6>
                </div>
                <div class="card-body p-0">
                    <nav class="toc-nav">
                        <ul class="nav nav-pills flex-column">
                            <li class="nav-item">
                                <a class="nav-link" href="#introduction">مقدمه</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#definitions">تعاریف</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#acceptance">پذیرش قوانین</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#eligibility">شرایط عضویت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#account">حساب کاربری</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#deposits">واریز و برداشت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#betting">قوانین شرط‌بندی</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#bonuses">جوایز و تخفیف‌ها</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#prohibited">فعالیت‌های ممنوع</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#responsible">بازی مسئولانه</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#privacy">حریم خصوصی</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#liability">مسئولیت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#termination">خاتمه خدمات</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#changes">تغییرات</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#contact">تماس با ما</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
        
        <div class="col-lg-9">
            <div class="terms-content">
                <!-- Introduction -->
                <section id="introduction" class="terms-section">
                    <h2><i class="fas fa-info-circle"></i> مقدمه</h2>
                    <div class="section-content">
                        <p class="lead">
                            به Crashify خوش آمدید. این قوانین و مقررات ("قوانین") شرایط استفاده از وب‌سایت و خدمات ما را تعیین می‌کند.
                        </p>
                        <p>
                            Crashify یک پلتفرم شرط‌بندی آنلاین است که خدمات بازی‌های کازینو، شرط‌بندی ورزشی و سایر بازی‌های شانسی را ارائه می‌دهد. 
                            با استفاده از خدمات ما، شما موافقت می‌کنید که تمام قوانین و مقررات ذکر شده در این سند را رعایت کنید.
                        </p>
                        <div class="alert alert-info">
                            <i class="fas fa-exclamation-circle"></i>
                            <strong>مهم:</strong> لطفاً این قوانین را به دقت مطالعه کنید. استفاده از خدمات ما به معنای پذیرش کامل این شرایط است.
                        </div>
                    </div>
                </section>
                
                <!-- Definitions -->
                <section id="definitions" class="terms-section">
                    <h2><i class="fas fa-book"></i> تعاریف</h2>
                    <div class="section-content">
                        <p>در این قوانین، اصطلاحات زیر دارای معانی مشخص شده هستند:</p>
                        <dl class="definitions-list">
                            <dt>"شرکت" یا "ما" یا "Crashify"</dt>
                            <dd>به شرکت ارائه‌دهنده خدمات Crashify اطلاق می‌شود.</dd>
                            
                            <dt>"کاربر" یا "شما"</dt>
                            <dd>هر شخصی که از خدمات ما استفاده می‌کند یا حساب کاربری دارد.</dd>
                            
                            <dt>"خدمات"</dt>
                            <dd>تمام خدمات ارائه شده توسط Crashify شامل بازی‌ها، شرط‌بندی، و سایر امکانات.</dd>
                            
                            <dt>"حساب کاربری"</dt>
                            <dd>حساب شخصی که کاربر برای استفاده از خدمات ایجاد می‌کند.</dd>
                            
                            <dt>"شرط‌بندی"</dt>
                            <dd>قرار گذاشتن پول روی نتیجه یک رویداد یا بازی.</dd>
                            
                            <dt>"موجودی"</dt>
                            <dd>مبلغ پولی که در حساب کاربری موجود است.</dd>
                            
                            <dt>"جایزه" یا "بونوس"</dt>
                            <dd>مبالغ اضافی که شرکت به کاربران اعطا می‌کند.</dd>
                        </dl>
                    </div>
                </section>
                
                <!-- Acceptance -->
                <section id="acceptance" class="terms-section">
                    <h2><i class="fas fa-handshake"></i> پذیرش قوانین</h2>
                    <div class="section-content">
                        <p>
                            با ایجاد حساب کاربری، استفاده از خدمات، یا کلیک بر روی "موافقم" در هنگام ثبت نام، 
                            شما تأیید می‌کنید که:
                        </p>
                        <ul>
                            <li>این قوانین و مقررات را به طور کامل خوانده و درک کرده‌اید</li>
                            <li>با تمام شرایط ذکر شده موافق هستید</li>
                            <li>قانوناً صلاحیت انعقاد این قرارداد را دارید</li>
                            <li>تمام اطلاعات ارائه شده صحیح و کامل است</li>
                        </ul>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            اگر با هر یک از این شرایط موافق نیستید، لطفاً از خدمات ما استفاده نکنید.
                        </div>
                    </div>
                </section>
                
                <!-- Eligibility -->
                <section id="eligibility" class="terms-section">
                    <h2><i class="fas fa-user-check"></i> شرایط عضویت</h2>
                    <div class="section-content">
                        <p>برای استفاده از خدمات Crashify، شما باید:</p>
                        <div class="eligibility-requirements">
                            <div class="requirement-item">
                                <i class="fas fa-birthday-cake text-primary"></i>
                                <div class="requirement-content">
                                    <h6>سن قانونی</h6>
                                    <p>حداقل 18 سال سن داشته باشید یا سن قانونی در کشور محل اقامت خود.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-globe text-success"></i>
                                <div class="requirement-content">
                                    <h6>محدودیت جغرافیایی</h6>
                                    <p>در کشوری زندگی کنید که شرط‌بندی آنلاین قانونی است.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-id-card text-info"></i>
                                <div class="requirement-content">
                                    <h6>هویت معتبر</h6>
                                    <p>مدارک هویتی معتبر برای تأیید حساب ارائه دهید.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-user-times text-danger"></i>
                                <div class="requirement-content">
                                    <h6>عدم محدودیت</h6>
                                    <p>قبلاً از خدمات ما محروم نشده باشید.</p>
                                </div>
                            </div>
                        </div>
                        
                        <h5>کشورهای محدود</h5>
                        <p>متأسفانه خدمات ما در کشورهای زیر قابل دسترس نیست:</p>
                        <div class="restricted-countries">
                            <span class="country-tag">آمریکا</span>
                            <span class="country-tag">فرانسه</span>
                            <span class="country-tag">اسپانیا</span>
                            <span class="country-tag">ایتالیا</span>
                            <span class="country-tag">بلژیک</span>
                            <span class="country-tag">هلند</span>
                        </div>
                    </div>
                </section>
                
                <!-- Account -->
                <section id="account" class="terms-section">
                    <h2><i class="fas fa-user-cog"></i> حساب کاربری</h2>
                    <div class="section-content">
                        <h5>ایجاد حساب</h5>
                        <ul>
                            <li>هر شخص فقط می‌تواند یک حساب کاربری داشته باشد</li>
                            <li>تمام اطلاعات ارائه شده باید صحیح و به‌روز باشد</li>
                            <li>شما مسئول حفظ امنیت رمز عبور خود هستید</li>
                            <li>هرگونه فعالیت در حساب شما، مسئولیت شما محسوب می‌شود</li>
                        </ul>
                        
                        <h5>تأیید هویت</h5>
                        <p>ما حق داریم در هر زمان مدارک زیر را از شما درخواست کنیم:</p>
                        <ul>
                            <li>کارت شناسایی معتبر (شناسنامه، گذرنامه، کارت ملی)</li>
                            <li>مدرک اثبات آدرس (قبض آب، برق، گاز)</li>
                            <li>مدارک مالی (صورتحساب بانکی، کارت اعتباری)</li>
                        </ul>
                        
                        <h5>مسئولیت‌های کاربر</h5>
                        <div class="alert alert-info">
                            <ul class="mb-0">
                                <li>حفظ محرمانگی اطلاعات حساب</li>
                                <li>اطلاع‌رسانی فوری در صورت سوء استفاده</li>
                                <li>به‌روزرسانی اطلاعات شخصی</li>
                                <li>رعایت تمام قوانین و مقررات</li>
                            </ul>
                        </div>
                    </div>
                </section>
                
                <!-- Deposits and Withdrawals -->
                <section id="deposits" class="terms-section">
                    <h2><i class="fas fa-credit-card"></i> واریز و برداشت</h2>
                    <div class="section-content">
                        <h5>واریز وجه</h5>
                        <ul>
                            <li>حداقل مبلغ واریز: $10</li>
                            <li>حداکثر مبلغ واریز: $10,000 در روز</li>
                            <li>تمام واریزها فوری پردازش می‌شوند</li>
                            <li>کارمزد واریز بر عهده کاربر است</li>
                        </ul>
                        
                        <h5>برداشت وجه</h5>
                        <ul>
                            <li>حداقل مبلغ برداشت: $20</li>
                            <li>حداکثر مبلغ برداشت: $5,000 در روز</li>
                            <li>زمان پردازش: 1-3 روز کاری</li>
                            <li>تأیید هویت برای برداشت الزامی است</li>
                        </ul>
                        
                        <h5>روش‌های پرداخت</h5>
                        <div class="payment-methods">
                            <div class="payment-method">
                                <i class="fab fa-cc-visa"></i>
                                <span>کارت‌های اعتباری</span>
                            </div>
                            <div class="payment-method">
                                <i class="fab fa-bitcoin"></i>
                                <span>ارزهای دیجیتال</span>
                            </div>
                            <div class="payment-method">
                                <i class="fas fa-university"></i>
                                <span>انتقال بانکی</span>
                            </div>
                            <div class="payment-method">
                                <i class="fab fa-paypal"></i>
                                <span>کیف پول‌های دیجیتال</span>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- Betting Rules -->
                <section id="betting" class="terms-section">
                    <h2><i class="fas fa-dice"></i> قوانین شرط‌بندی</h2>
                    <div class="section-content">
                        <h5>قوانین عمومی</h5>
                        <ul>
                            <li>تمام شرط‌ها نهایی و غیرقابل تغییر هستند</li>
                            <li>حداقل مبلغ شرط: $1</li>
                            <li>حداکثر مبلغ شرط: $1,000 (بسته به بازی)</li>
                            <li>نتایج بازی‌ها بر اساس الگوریتم‌های تأیید شده تعیین می‌شود</li>
                        </ul>
                        
                        <h5>بازی‌های کازینو</h5>
                        <ul>
                            <li>تمام بازی‌ها دارای RTP (Return to Player) مشخص هستند</li>
                            <li>نتایج بازی‌ها کاملاً تصادفی و قابل تأیید هستند</li>
                            <li>هیچ‌گونه دخالت در نتایج بازی‌ها صورت نمی‌گیرد</li>
                        </ul>
                        
                        <h5>شرط‌بندی ورزشی</h5>
                        <ul>
                            <li>شرط‌ها بر اساس نتایج رسمی تعیین می‌شوند</li>
                            <li>در صورت لغو مسابقه، شرط‌ها باطل می‌شوند</li>
                            <li>ضرایب ممکن است تا لحظه شروع مسابقه تغییر کنند</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>هشدار:</strong> شرط‌بندی می‌تواند اعتیادآور باشد. لطفاً مسئولانه بازی کنید.
                        </div>
                    </div>
                </section>
                
                <!-- Bonuses -->
                <section id="bonuses" class="terms-section">
                    <h2><i class="fas fa-gift"></i> جوایز و تخفیف‌ها</h2>
                    <div class="section-content">
                        <h5>شرایط عمومی</h5>
                        <ul>
                            <li>تمام جوایز دارای شرایط گردش (Wagering) هستند</li>
                            <li>هر کاربر فقط یک بار از هر جایزه می‌تواند استفاده کند</li>
                            <li>جوایز دارای تاریخ انقضا هستند</li>
                            <li>سوء استفاده از جوایز منجر به لغو حساب می‌شود</li>
                        </ul>
                        
                        <h5>انواع جوایز</h5>
                        <div class="bonus-types">
                            <div class="bonus-type">
                                <h6><i class="fas fa-hand-holding-heart"></i> جایزه خوش‌آمدگویی</h6>
                                <p>100% تا $500 برای اولین واریز + 50 اسپین رایگان</p>
                                <small>شرایط گردش: 35x</small>
                            </div>
                            
                            <div class="bonus-type">
                                <h6><i class="fas fa-coins"></i> جایزه واریز</h6>
                                <p>50% تا $200 برای واریزهای بعدی</p>
                                <small>شرایط گردش: 25x</small>
                            </div>
                            
                            <div class="bonus-type">
                                <h6><i class="fas fa-undo-alt"></i> بازگشت وجه</h6>
                                <p>10% از ضررهای هفتگی تا $100</p>
                                <small>شرایط گردش: 15x</small>
                            </div>
                        </div>
                        
                        <h5>محاسبه شرایط گردش</h5>
                        <p>
                            شرایط گردش به معنای تعداد دفعاتی است که باید مبلغ جایزه را شرط‌بندی کنید. 
                            مثال: جایزه $100 با شرایط گردش 20x = $2,000 شرط‌بندی مورد نیاز.
                        </p>
                    </div>
                </section>
                
                <!-- Prohibited Activities -->
                <section id="prohibited" class="terms-section">
                    <h2><i class="fas fa-ban"></i> فعالیت‌های ممنوع</h2>
                    <div class="section-content">
                        <p>فعالیت‌های زیر اکیداً ممنوع بوده و منجر به تعلیق یا لغو حساب می‌شود:</p>
                        
                        <div class="prohibited-activities">
                            <div class="prohibited-item">
                                <i class="fas fa-users-slash text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>حساب‌های متعدد</h6>
                                    <p>ایجاد بیش از یک حساب کاربری</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-robot text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>استفاده از ربات</h6>
                                    <p>استفاده از نرم‌افزارهای خودکار برای بازی</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-handshake-slash text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>تبانی</h6>
                                    <p>همکاری با سایر کاربران برای تقلب</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-money-bill-wave-alt text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>پولشویی</h6>
                                    <p>استفاده از پلتفرم برای پولشویی</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-bug text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>سوء استفاده از باگ</h6>
                                    <p>استفاده از اشکالات سیستم برای سود</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-share-alt text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>اشتراک حساب</h6>
                                    <p>اجازه استفاده از حساب به دیگران</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- Responsible Gaming -->
                <section id="responsible" class="terms-section">
                    <h2><i class="fas fa-shield-alt"></i> بازی مسئولانه</h2>
                    <div class="section-content">
                        <p>
                            ما متعهد به ترویج بازی مسئولانه هستیم و ابزارهای زیر را برای کمک به کاربران فراهم کرده‌ایم:
                        </p>
                        
                        <div class="responsible-tools">
                            <div class="tool-item">
                                <i class="fas fa-dollar-sign text-primary"></i>
                                <span>محدودیت واریز</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-coins text-primary"></i>
                                <span>محدودیت ضرر</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-clock text-primary"></i>
                                <span>محدودیت زمان</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-pause text-primary"></i>
                                <span>استراحت موقت</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-ban text-primary"></i>
                                <span>خودمحدودسازی</span>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            برای اطلاعات بیشتر درباره بازی مسئولانه، 
                            <a href="/pages/responsible-gambling.php">اینجا کلیک کنید</a>.
                        </div>
                    </div>
                </section>
                
                <!-- Privacy -->
                <section id="privacy" class="terms-section">
                    <h2><i class="fas fa-user-shield"></i> حریم خصوصی</h2>
                    <div class="section-content">
                        <p>
                            حفظ حریم خصوصی شما برای ما بسیار مهم است. ما متعهد به:
                        </p>
                        <ul>
                            <li>محافظت از اطلاعات شخصی شما</li>
                            <li>عدم فروش اطلاعات به اشخاص ثالث</li>
                            <li>استفاده از اطلاعات فقط برای ارائه خدمات</li>
                            <li>رعایت قوانین حفاظت از داده‌ها</li>
                        </ul>
                        
                        <p>
                            برای اطلاعات کامل درباره نحوه جمع‌آوری و استفاده از اطلاعات، 
                            لطفاً <a href="/pages/privacy.php">سیاست حریم خصوصی</a> ما را مطالعه کنید.
                        </p>
                    </div>
                </section>
                
                <!-- Liability -->
                <section id="liability" class="terms-section">
                    <h2><i class="fas fa-balance-scale"></i> مسئولیت</h2>
                    <div class="section-content">
                        <h5>محدودیت مسئولیت</h5>
                        <p>
                            Crashify در حد امکان تلاش می‌کند خدمات مطمئن و قابل اعتماد ارائه دهد، اما:
                        </p>
                        <ul>
                            <li>مسئولیتی در قبال ضررهای غیرمستقیم ندارد</li>
                            <li>خدمات "همان‌طور که هست" ارائه می‌شود</li>
                            <li>ممکن است خدمات موقتاً قطع شود</li>
                            <li>مسئولیت کل ما محدود به موجودی حساب شما است</li>
                        </ul>
                        
                        <h5>مسئولیت کاربر</h5>
                        <p>شما مسئول:</p>
                        <ul>
                            <li>رعایت قوانین محلی کشور خود</li>
                            <li>پرداخت مالیات‌های مربوطه</li>
                            <li>استفاده مسئولانه از خدمات</li>
                            <li>حفظ امنیت حساب کاربری</li>
                        </ul>
                    </div>
                </section>
                
                <!-- Termination -->
                <section id="termination" class="terms-section">
                    <h2><i class="fas fa-times-circle"></i> خاتمه خدمات</h2>
                    <div class="section-content">
                        <h5>خاتمه توسط کاربر</h5>
                        <p>شما می‌توانید در هر زمان:</p>
                        <ul>
                            <li>حساب خود را بستید</li>
                            <li>موجودی خود را برداشت کنید</li>
                            <li>استفاده از خدمات را متوقف کنید</li>
                        </ul>
                        
                        <h5>خاتمه توسط شرکت</h5>
                        <p>ما حق داریم در موارد زیر حساب شما را تعلیق یا لغو کنیم:</p>
                        <ul>
                            <li>نقض قوانین و مقررات</li>
                            <li>فعالیت‌های مشکوک یا تقلب</li>
                            <li>عدم تأیید هویت</li>
                            <li>درخواست مقامات قانونی</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            در صورت لغو حساب، موجودی قانونی شما بازگردانده خواهد شد.
                        </div>
                    </div>
                </section>
                
                <!-- Changes -->
                <section id="changes" class="terms-section">
                    <h2><i class="fas fa-edit"></i> تغییرات</h2>
                    <div class="section-content">
                        <p>
                            ما حق داریم این قوانین و مقررات را در هر زمان تغییر دهیم. تغییرات مهم از طریق:
                        </p>
                        <ul>
                            <li>ایمیل به کاربران اطلاع‌رسانی می‌شود</li>
                            <li>در وب‌سایت اعلام می‌شود</li>
                            <li>در حساب کاربری نمایش داده می‌شود</li>
                        </ul>
                        
                        <p>
                            ادامه استفاده از خدمات پس از اعلام تغییرات، به معنای پذیرش آن‌ها است.
                        </p>
                    </div>
                </section>
                
                <!-- Contact -->
                <section id="contact" class="terms-section">
                    <h2><i class="fas fa-envelope"></i> تماس با ما</h2>
                    <div class="section-content">
                        <p>
                            اگر سوالی درباره این قوانین و مقررات دارید، می‌توانید با ما تماس بگیرید:
                        </p>
                        
                        <div class="contact-info">
                            <div class="contact-item">
                                <i class="fas fa-envelope text-primary"></i>
                                <div class="contact-details">
                                    <strong>ایمیل:</strong>
                                    <a href="mailto:legal@crashify.com">legal@crashify.com</a>
                                </div>
                            </div>
                            
                            <div class="contact-item">
                                <i class="fas fa-headset text-success"></i>
                                <div class="contact-details">
                                    <strong>پشتیبانی:</strong>
                                    <a href="/pages/support.php">مرکز پشتیبانی</a>
                                </div>
                            </div>
                            
                            <div class="contact-item">
                                <i class="fas fa-clock text-info"></i>
                                <div class="contact-details">
                                    <strong>ساعات کاری:</strong>
                                    24 ساعته، 7 روز هفته
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 2rem;
    padding: 2rem 0;
}

.last-updated {
    margin-top: 1rem;
}

.toc-nav {
    max-height: 70vh;
    overflow-y: auto;
}

.toc-nav .nav-link {
    color: #6c757d;
    font-size: 0.9rem;
    padding: 0.5rem 1rem;
    border-radius: 0;
    border-left: 3px solid transparent;
}

.toc-nav .nav-link:hover,
.toc-nav .nav-link.active {
    color: #007bff;
    background-color: #f8f9fa;
    border-left-color: #007bff;
}

.terms-content {
    padding-left: 2rem;
}

.terms-section {
    margin-bottom: 3rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e9ecef;
}

.terms-section:last-child {
    border-bottom: none;
}

.terms-section h2 {
    color: #495057;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
}

.terms-section h2 i {
    margin-right: 0.75rem;
    color: #007bff;
}

.section-content {
    line-height: 1.7;
}

.section-content p {
    margin-bottom: 1rem;
}

.section-content ul,
.section-content ol {
    margin-bottom: 1.5rem;
}

.section-content li {
    margin-bottom: 0.5rem;
}

.definitions-list dt {
    font-weight: 600;
    color: #495057;
    margin-top: 1rem;
    margin-bottom: 0.5rem;
}

.definitions-list dd {
    margin-bottom: 1rem;
    margin-left: 1rem;
    color: #6c757d;
}

.eligibility-requirements {
    margin: 2rem 0;
}

.requirement-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.requirement-item i {
    font-size: 2rem;
    margin-right: 1rem;
    margin-top: 0.25rem;
}

.requirement-content h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.requirement-content p {
    margin: 0;
    color: #6c757d;
}

.restricted-countries {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-top: 1rem;
}

.country-tag {
    background: #dc3545;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 15px;
    font-size: 0.875rem;
}

.payment-methods {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-top: 1rem;
}

.payment-method {
    display: flex;
    align-items: center;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    min-width: 150px;
}

.payment-method i {
    font-size: 1.5rem;
    margin-right: 0.75rem;
    color: #007bff;
}

.bonus-types {
    margin: 2rem 0;
}

.bonus-type {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #007bff;
}

.bonus-type h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
}

.bonus-type h6 i {
    margin-right: 0.5rem;
    color: #007bff;
}

.bonus-type p {
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.bonus-type small {
    color: #6c757d;
}

.prohibited-activities {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
    margin: 2rem 0;
}

.prohibited-item {
    display: flex;
    align-items: flex-start;
    padding: 1.5rem;
    background: #fff5f5;
    border: 1px solid #fed7d7;
    border-radius: 10px;
}

.prohibited-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
    margin-top: 0.25rem;
}

.prohibited-content h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.prohibited-content p {
    margin: 0;
    color: #6c757d;
    font-size: 0.9rem;
}

.responsible-tools {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin: 1.5rem 0;
}

.tool-item {
    display: flex;
    align-items: center;
    padding: 0.75rem 1rem;
    background: #e3f2fd;
    border-radius: 25px;
    font-size: 0.9rem;
}

.tool-item i {
    margin-right: 0.5rem;
}

.contact-info {
    margin-top: 2rem;
}

.contact-item {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.contact-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
}

.contact-details strong {
    display: block;
    color: #495057;
    margin-bottom: 0.25rem;
}

.contact-details a {
    color: #007bff;
    text-decoration: none;
}

.contact-details a:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .terms-content {
        padding-left: 0;
    }
    
    .requirement-item,
    .prohibited-item {
        flex-direction: column;
        text-align: center;
    }
    
    .requirement-item i,
    .prohibited-item i {
        margin-right: 0;
        margin-bottom: 1rem;
    }
    
    .payment-methods {
        flex-direction: column;
    }
    
    .payment-method {
        justify-content: center;
    }
    
    .responsible-tools {
        flex-direction: column;
    }
    
    .tool-item {
        justify-content: center;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Smooth scrolling for table of contents
    const tocLinks = document.querySelectorAll('.toc-nav .nav-link');
    
    tocLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href').substring(1);
            const targetElement = document.getElementById(targetId);
            
            if (targetElement) {
                // Remove active class from all links
                tocLinks.forEach(l => l.classList.remove('active'));
                
                // Add active class to clicked link
                this.classList.add('active');
                
                // Smooth scroll to target
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Update active link on scroll
    const sections = document.querySelectorAll('.terms-section');
    const navLinks = document.querySelectorAll('.toc-nav .nav-link');
    
    function updateActiveLink() {
        let current = '';
        
        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            const sectionHeight = section.clientHeight;
            
            if (window.pageYOffset >= sectionTop - 100) {
                current = section.getAttribute('id');
            }
        });
        
        navLinks.forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('href') === '#' + current) {
                link.classList.add('active');
            }
        });
    }
    
    window.addEventListener('scroll', updateActiveLink);
    updateActiveLink(); // Initial call
});
</script>

<?php include '../includes/footer.php'; ?>
