<?php
// languages/fa.php - Persian/Farsi Language File
// فایل زبان فارسی برای سایت Crashify

return [
    // Common/General
    'common' => [
        'loading' => 'در حال بارگذاری...',
        'save' => 'ذخیره',
        'cancel' => 'لغو',
        'delete' => 'حذف',
        'edit' => 'ویرایش',
        'view' => 'مشاهده',
        'search' => 'جستجو',
        'filter' => 'فیلتر',
        'sort' => 'مرتب‌سازی',
        'refresh' => 'بروزرسانی',
        'back' => 'بازگشت',
        'next' => 'بعدی',
        'previous' => 'قبلی',
        'submit' => 'ارسال',
        'confirm' => 'تأیید',
        'yes' => 'بله',
        'no' => 'خیر',
        'ok' => 'تأیید',
        'close' => 'بستن',
        'open' => 'باز کردن',
        'live' => 'زنده',
        'new' => 'جدید',
        'hot' => 'داغ',
        'popular' => 'محبوب',
        'featured' => 'ویژه',
        'coming_soon' => 'به زودی',
        'maintenance' => 'در حال تعمیر',
        'error' => 'خطا',
        'success' => 'موفقیت',
        'warning' => 'هشدار',
        'info' => 'اطلاعات',
        'live_updates' => 'بروزرسانی زنده',
        'back_to_top' => 'بازگشت به بالا'
    ],

    // Site Information
    'site' => [
        'tagline' => 'بهترین پلتفرم شرط‌بندی کریپتو',
        'welcome' => 'به کرشیفای خوش آمدید',
        'description' => 'آینده شرط‌بندی آنلاین را با پرداخت‌های فوری کریپتو، شرط‌بندی زنده ورزشی و بازی‌های کازینو پریمیوم تجربه کنید.'
    ],

    // Navigation
    'nav' => [
        'home' => 'خانه',
        'sportsbook' => 'شرط‌بندی ورزشی',
        'live_betting' => 'شرط‌بندی زنده',
        'casino' => 'کازینو',
        'esports' => 'ورزش‌های الکترونیک',
        'virtual_sports' => 'ورزش‌های مجازی',
        'lottery' => 'لاتاری',
        'bonuses' => 'جوایز',
        'more' => 'بیشتر',
        'promotions' => 'تبلیغات',
        'vip' => 'وی‌آی‌پی',
        'tournaments' => 'مسابقات'
    ],

    // Authentication
    'auth' => [
        'login' => 'ورود',
        'register' => 'ثبت‌نام',
        'logout' => 'خروج',
        'forgot_password' => 'رمز عبور را فراموش کرده‌اید؟',
        'reset_password' => 'بازنشانی رمز عبور',
        'change_password' => 'تغییر رمز عبور',
        'email' => 'ایمیل',
        'username' => 'نام کاربری',
        'password' => 'رمز عبور',
        'confirm_password' => 'تأیید رمز عبور',
        'remember_me' => 'مرا به خاطر بسپار',
        'login_success' => 'ورود موفقیت‌آمیز! خوش برگشتید.',
        'login_failed' => 'ورود ناموفق. لطفاً دوباره تلاش کنید.',
        'logout_success' => 'با موفقیت خارج شدید.',
        'registration_success' => 'ثبت‌نام موفقیت‌آمیز! لطفاً ایمیل خود را برای تأیید حساب بررسی کنید.',
        'registration_failed' => 'ثبت‌نام ناموفق. لطفاً دوباره تلاش کنید.',
        'invalid_credentials' => 'ایمیل/نام کاربری یا رمز عبور نامعتبر.',
        'account_locked' => 'حساب به دلیل تلاش‌های ناموفق زیاد قفل شده. {minutes} دقیقه دیگر تلاش کنید.',
        'account_inactive' => 'حساب شما غیرفعال است. لطفاً با پشتیبانی تماس بگیرید.',
        'user_exists' => 'کاربری با این ایمیل یا نام کاربری قبلاً وجود دارد.',
        'invalid_username' => 'نام کاربری باید حداقل ۳ کاراکتر باشد.',
        'invalid_email' => 'لطفاً یک آدرس ایمیل معتبر وارد کنید.',
        'invalid_password_format' => 'رمز عبور باید حداقل ۸ کاراکتر با حروف بزرگ، کوچک و عدد باشد.',
        'email_verified' => 'ایمیل با موفقیت تأیید شد! اکنون می‌توانید وارد شوید.',
        'invalid_verification_token' => 'توکن تأیید نامعتبر یا منقضی شده.',
        'verification_failed' => 'تأیید ایمیل ناموفق. لطفاً دوباره تلاش کنید.',
        'reset_email_sent' => 'اگر حسابی با این ایمیل وجود داشته باشد، دستورالعمل بازنشانی رمز عبور دریافت خواهید کرد.',
        'reset_request_failed' => 'درخواست بازنشانی رمز عبور ناموفق. لطفاً دوباره تلاش کنید.',
        'password_reset_success' => 'رمز عبور با موفقیت بازنشانی شد! اکنون می‌توانید با رمز عبور جدید وارد شوید.',
        'password_reset_failed' => 'بازنشانی رمز عبور ناموفق. لطفاً دوباره تلاش کنید.',
        'invalid_reset_token' => 'توکن بازنشانی نامعتبر یا منقضی شده.',
        'confirm_logout' => 'آیا مطمئن هستید که می‌خواهید خارج شوید؟',
        'verification_email_subject' => 'تأیید حساب کرشیفای شما',
        'verification_email_body' => 'برای تأیید حساب خود روی لینک زیر کلیک کنید: {url}',
        'reset_email_subject' => 'بازنشانی رمز عبور کرشیفای',
        'reset_email_body' => 'برای بازنشانی رمز عبور خود روی لینک زیر کلیک کنید: {url}',
        'two_factor_enabled' => 'احراز هویت دو مرحله‌ای با موفقیت فعال شد.',
        'two_factor_code' => 'کد دو مرحله‌ای',
        'invalid_2fa_code' => 'کد احراز هویت دو مرحله‌ای نامعتبر.'
    ],

    // User Profile & Account
    'user' => [
        'profile' => 'پروفایل',
        'account' => 'حساب',
        'settings' => 'تنظیمات',
        'wallet' => 'کیف پول',
        'bet_history' => 'تاریخچه شرط‌ها',
        'transaction_history' => 'تاریخچه تراکنش‌ها',
        'bonuses' => 'جوایز من',
        'support' => 'پشتیبانی',
        'preferences' => 'ترجیحات',
        'security' => 'امنیت',
        'verification' => 'تأیید هویت',
        'first_name' => 'نام',
        'last_name' => 'نام خانوادگی',
        'phone' => 'شماره تلفن',
        'country' => 'کشور',
        'date_of_birth' => 'تاریخ تولد',
        'address' => 'آدرس',
        'city' => 'شهر',
        'postal_code' => 'کد پستی',
        'total_bets' => 'کل شرط‌ها',
        'win_rate' => 'نرخ برد',
        'total_winnings' => 'کل برد',
        'level' => 'سطح',
        'vip_status' => 'وضعیت وی‌آی‌پی',
        'joined_date' => 'عضو از',
        'last_login' => 'آخرین ورود',
        'account_status' => 'وضعیت حساب',
        'email_verified' => 'ایمیل تأیید شده',
        'phone_verified' => 'تلفن تأیید شده',
        'identity_verified' => 'هویت تأیید شده'
    ],

    // Wallet & Payments
    'wallet' => [
        'my_wallet' => 'کیف پول من',
        'balance' => 'موجودی',
        'main_balance' => 'موجودی اصلی',
        'bonus_balance' => 'موجودی جایزه',
        'deposit' => 'واریز',
        'withdraw' => 'برداشت',
        'transfer' => 'انتقال',
        'transaction_history' => 'تاریخچه تراکنش‌ها',
        'pending_transactions' => 'تراکنش‌های در انتظار',
        'deposit_address' => 'آدرس واریز',
        'withdrawal_address' => 'آدرس برداشت',
        'amount' => 'مقدار',
        'currency' => 'ارز',
        'fee' => 'کارمزد',
        'total' => 'مجموع',
        'minimum_deposit' => 'حداقل واریز',
        'maximum_deposit' => 'حداکثر واریز',
        'minimum_withdrawal' => 'حداقل برداشت',
        'maximum_withdrawal' => 'حداکثر برداشت',
        'processing_time' => 'زمان پردازش',
        'instant' => 'فوری',
        'confirmations_required' => 'تأیید مورد نیاز',
        'transaction_id' => 'شناسه تراکنش',
        'status' => 'وضعیت',
        'pending' => 'در انتظار',
        'completed' => 'تکمیل شده',
        'failed' => 'ناموفق',
        'cancelled' => 'لغو شده',
        'deposit_success' => 'واریز با موفقیت انجام شد!',
        'withdrawal_success' => 'درخواست برداشت با موفقیت ارسال شد!',
        'insufficient_balance' => 'موجودی ناکافی.',
        'invalid_address' => 'آدرس کیف پول نامعتبر.',
        'invalid_amount' => 'مقدار نامعتبر.',
        'deposit_instructions' => 'ارز دیجیتال خود را به آدرس زیر ارسال کنید. موجودی شما پس از تأیید شبکه بروزرسانی خواهد شد.',
        'withdrawal_warning' => 'آدرس برداشت را دوباره بررسی کنید. تراکنش‌های ارز دیجیتال غیرقابل بازگشت هستند.',
        'copy_address' => 'کپی آدرس',
        'address_copied' => 'آدرس در کلیپ‌بورد کپی شد!',
        'generate_new_address' => 'تولید آدرس جدید'
    ],

    // Sports & Betting
    'sports' => [
        'football' => 'فوتبال',
        'basketball' => 'بسکتبال',
        'tennis' => 'تنیس',
        'baseball' => 'بیسبال',
        'hockey' => 'هاکی',
        'soccer' => 'فوتبال',
        'american_football' => 'فوتبال آمریکایی',
        'volleyball' => 'والیبال',
        'cricket' => 'کریکت',
        'rugby' => 'راگبی',
        'golf' => 'گلف',
        'boxing' => 'بوکس',
        'mma' => 'هنرهای رزمی ترکیبی',
        'motorsports' => 'ورزش‌های موتوری',
        'cycling' => 'دوچرخه‌سواری',
        'swimming' => 'شنا',
        'athletics' => 'دو و میدانی',
        'winter_sports' => 'ورزش‌های زمستانی'
    ],

    // Betting
    'betting' => [
        'bet_slip' => 'برگه شرط',
        'place_bet' => 'ثبت شرط',
        'place_bets' => 'ثبت شرط‌ها',
        'add_to_bet_slip' => 'افزودن به برگه شرط',
        'remove_from_bet_slip' => 'حذف از برگه شرط',
        'clear_bet_slip' => 'پاک کردن برگه شرط',
        'empty_bet_slip' => 'برگه شرط شما خالی است. برای شروع چند انتخاب اضافه کنید!',
        'stake' => 'مبلغ شرط',
        'total_stake' => 'کل مبلغ شرط',
        'odds' => 'ضریب',
        'potential_payout' => 'برد احتمالی',
        'potential_profit' => 'سود احتمالی',
        'bet_type' => 'نوع شرط',
        'single_bet' => 'شرط تکی',
        'accumulator' => 'شرط ترکیبی',
        'system_bet' => 'شرط سیستمی',
        'live_bet' => 'شرط زنده',
        'pre_match' => 'پیش از بازی',
        'in_play' => 'در حین بازی',
        'match_result' => 'نتیجه بازی',
        'over_under' => 'بالا/پایین',
        'both_teams_score' => 'گل زدن هر دو تیم',
        'correct_score' => 'نتیجه دقیق',
        'first_goalscorer' => 'اولین گلزن',
        'handicap' => 'هندیکپ',
        'double_chance' => 'شانس دوگانه',
        'draw_no_bet' => 'مساوی بدون شرط',
        'win' => 'برد',
        'lose' => 'باخت',
        'push' => 'مساوی',
        'void' => 'باطل',
        'settled' => 'تسویه شده',
        'unsettled' => 'تسویه نشده',
        'bet_placed' => 'شرط با موفقیت ثبت شد!',
        'bet_failed' => 'ثبت شرط ناموفق. لطفاً دوباره تلاش کنید.',
        'minimum_stake' => 'حداقل مبلغ شرط: {amount}',
        'maximum_stake' => 'حداکثر مبلغ شرط: {amount}',
        'maximum_payout' => 'حداکثر برد: {amount}',
        'odds_changed' => 'ضرایب تغییر کرده‌اند. لطفاً شرط خود را تأیید کنید.',
        'event_suspended' => 'این رویداد در حال حاضر متوقف شده است.',
        'market_closed' => 'این بازار بسته است.',
        'bet_limit_exceeded' => 'حد شرط تجاوز شده.',
        'accept_odds_changes' => 'پذیرش تغییرات ضریب',
        'reject_odds_changes' => 'رد تغییرات ضریب'
    ],

    // Casino
    'casino' => [
        'slots' => 'اسلات',
        'table_games' => 'بازی‌های میز',
        'live_casino' => 'کازینو زنده',
        'crash_games' => 'بازی‌های کرش',
        'jackpots' => 'جک‌پات',
        'tournaments' => 'مسابقات',
        'new_games' => 'بازی‌های جدید',
        'popular_games' => 'بازی‌های محبوب',
        'blackjack' => 'بلک‌جک',
        'roulette' => 'رولت',
        'baccarat' => 'باکارات',
        'poker' => 'پوکر',
        'dice' => 'تاس',
        'keno' => 'کنو',
        'scratch_cards' => 'کارت‌های خراشی',
        'video_poker' => 'ویدیو پوکر',
        'play_now' => 'بازی کنید',
        'play_for_fun' => 'بازی تفریحی',
        'play_for_real' => 'بازی واقعی',
        'game_loading' => 'بارگذاری بازی...',
        'game_error' => 'بارگذاری بازی ناموفق. لطفاً دوباره تلاش کنید.',
        'insufficient_balance' => 'موجودی ناکافی برای این بازی.',
        'bet_amount' => 'مبلغ شرط',
        'spin' => 'چرخش',
        'deal' => 'پخش',
        'hit' => 'کارت',
        'stand' => 'ایست',
        'double' => 'دوبرابر',
        'split' => 'تقسیم',
        'insurance' => 'بیمه',
        'surrender' => 'تسلیم',
        'auto_play' => 'بازی خودکار',
        'max_bet' => 'حداکثر شرط',
        'game_history' => 'تاریخچه بازی',
        'game_rules' => 'قوانین بازی',
        'paytable' => 'جدول پرداخت',
        'jackpot_amount' => 'مبلغ جک‌پات',
        'progressive_jackpot' => 'جک‌پات پیشرونده',
        'free_spins' => 'چرخش‌های رایگان',
        'bonus_round' => 'دور جایزه',
        'multiplier' => 'ضریب',
        'wild_symbol' => 'نماد وحشی',
        'scatter_symbol' => 'نماد پراکنده'
    ],

    // Bonuses & Promotions
    'bonuses' => [
        'all_bonuses' => 'همه جوایز',
        'active_bonuses' => 'جوایز فعال',
        'bonus_history' => 'تاریخچه جوایز',
        'welcome_bonus' => 'جایزه خوش‌آمدگویی',
        'deposit_bonus' => 'جایزه واریز',
        'reload_bonus' => 'جایزه بارگذاری مجدد',
        'no_deposit_bonus' => 'جایزه بدون واریز',
        'free_bet' => 'شرط رایگان',
        'free_spins' => 'چرخش‌های رایگان',
        'cashback' => 'بازگشت وجه',
        'vip_program' => 'برنامه وی‌آی‌پی',
        'referral_program' => 'برنامه معرفی',
        'loyalty_points' => 'امتیاز وفاداری',
        'bonus_code' => 'کد جایزه',
        'claim_bonus' => 'دریافت جایزه',
        'bonus_claimed' => 'جایزه با موفقیت دریافت شد!',
        'bonus_expired' => 'این جایزه منقضی شده است.',
        'bonus_requirements' => 'شرایط جایزه',
        'wagering_requirement' => 'شرط شرط‌بندی',
        'minimum_deposit' => 'حداقل واریز',
        'maximum_bonus' => 'حداکثر جایزه',
        'valid_until' => 'معتبر تا',
        'terms_and_conditions' => 'شرایط و ضوابط',
        'bonus_balance' => 'موجودی جایزه',
        'wagering_progress' => 'پیشرفت شرط‌بندی',
        'remaining_wagering' => 'شرط‌بندی باقی‌مانده',
        'hot_offer' => 'پیشنهاد داغ',
        'limited_time' => 'زمان محدود',
        'exclusive_offer' => 'پیشنهاد انحصاری',
        'welcome_offer_text' => '۱۰۰٪ جایزه تا ۱۰۰۰ دلار + ۱۰۰ چرخش رایگان در اولین واریز!'
    ],

    // Support & Help
    'support' => [
        'help_center' => 'مرکز راهنمایی',
        'live_chat' => 'گفتگوی زنده',
        'contact_us' => 'تماس با ما',
        'faq' => 'سوالات متداول',
        'chat' => 'گفتگو',
        'support_ticket' => 'تیکت پشتیبانی',
        'create_ticket' => 'ایجاد تیکت',
        'ticket_history' => 'تاریخچه تیکت‌ها',
        'subject' => 'موضوع',
        'message' => 'پیام',
        'priority' => 'اولویت',
        'low' => 'کم',
        'medium' => 'متوسط',
        'high' => 'زیاد',
        'urgent' => 'فوری',
        'ticket_submitted' => 'تیکت پشتیبانی با موفقیت ارسال شد!',
        'response_time' => 'زمان پاسخ',
        'average_response' => 'میانگین زمان پاسخ: ۲ ساعت',
        '24_7_chat' => 'گفتگوی زنده ۲۴/۷',
        'online_support' => 'پشتیبانی آنلاین',
        'offline_support' => 'آفلاین - پیام بگذارید',
        'responsible_gaming' => 'بازی مسئولانه',
        'security' => 'امنیت و حریم خصوصی',
        'how_to_deposit' => 'نحوه واریز',
        'how_to_withdraw' => 'نحوه برداشت',
        'account_verification' => 'تأیید حساب',
        'betting_rules' => 'قوانین شرط‌بندی',
        'casino_rules' => 'قوانین کازینو',
        'bonus_terms' => 'شرایط جایزه',
        'technical_issues' => 'مشکلات فنی',
        'payment_issues' => 'مشکلات پرداخت',
        'general_inquiry' => 'سوال عمومی'
    ],

    // Notifications
    'notifications' => [
        'title' => 'اعلان‌ها',
        'mark_all_read' => 'همه را خوانده علامت‌گذاری کن',
        'view_all' => 'مشاهده همه',
        'no_notifications' => 'اعلان جدیدی نیست',
        'bet_won' => 'تبریک! شرط شما برنده شد.',
        'bet_lost' => 'شرط شما ناموفق بود.',
        'deposit_confirmed' => 'واریز شما تأیید شد.',
        'withdrawal_processed' => 'برداشت شما پردازش شد.',
        'bonus_credited' => 'جایزه به حساب شما واریز شد.',
        'new_promotion' => 'تبلیغ جدید موجود است!',
        'account_verified' => 'حساب شما تأیید شد.',
        'security_alert' => 'هشدار امنیتی: ورود جدید شناسایی شد.',
        'maintenance_notice' => 'اطلاعیه تعمیر برنامه‌ریزی شده.',
        'game_update' => 'بازی‌های جدید اضافه شدند!',
        'tournament_reminder' => 'مسابقه به زودی شروع می‌شود!',
        'vip_invitation' => 'شما به برنامه وی‌آی‌پی ما دعوت شده‌اید!'
    ],

    // Footer
    'footer' => [
        'company_description' => 'معتبرترین پلتفرم شرط‌بندی کریپتو با پرداخت‌های فوری، شرط‌بندی زنده ورزشی و بازی‌های کازینو پریمیوم. دارای مجوز و تنظیم شده برای امنیت شما.',
        'sports_betting' => 'شرط‌بندی ورزشی',
        'casino_games' => 'بازی‌های کازینو',
        'crypto_payments' => 'کریپتو و پرداخت‌ها',
        'support_help' => 'پشتیبانی و راهنمایی',
        'promotions' => 'تبلیغات و جوایز',
        'active_users' => 'کاربران فعال',
        'daily_volume' => 'حجم روزانه',
        'uptime' => 'زمان فعالیت',
        'all_rights_reserved' => 'تمام حقوق محفوظ است.',
        'license_info' => 'دارای مجوز و تنظیم شده. قمار می‌تواند اعتیادآور باشد. مسئولانه بازی کنید.',
        'ssl_secured' => 'امن با SSL',
        'fair_gaming' => 'بازی عادلانه',
        'age_verification' => 'برای استفاده از این وب‌سایت باید ۱۸ سال یا بیشتر داشته باشید. قمار می‌تواند اعتیادآور باشد. مسئولانه بازی کنید.'
    ],

    // Legal
    'legal' => [
        'terms_conditions' => 'شرایط و ضوابط',
        'privacy_policy' => 'سیاست حریم خصوصی',
        'cookie_policy' => 'سیاست کوکی',
        'responsible_gaming' => 'بازی مسئولانه',
        'aml_policy' => 'سیاست ضد پولشویی',
        'kyc_policy' => 'سیاست شناخت مشتری'
    ],

    // Newsletter
    'newsletter' => [
        'title' => 'به‌روز بمانید',
        'description' => 'در خبرنامه ما عضو شوید تا جوایز انحصاری، تبلیغات و نکات شرط‌بندی دریافت کنید.',
        'email_placeholder' => 'آدرس ایمیل خود را وارد کنید',
        'subscribe' => 'عضویت',
        'subscribed' => 'با موفقیت عضو شدید!',
        'benefit_1' => 'جوایز انحصاری',
        'benefit_2' => 'آخرین تبلیغات',
        'benefit_3' => 'نکات و بینش‌های شرط‌بندی'
    ],

    // Cookies
    'cookies' => [
        'consent_message' => 'ما از کوکی‌ها برای بهبود تجربه شما و ارائه محتوای شخصی‌سازی شده استفاده می‌کنیم. با ادامه استفاده از سایت ما، با سیاست کوکی ما موافقت می‌کنید.',
        'accept_all' => 'پذیرش همه',
        'settings' => 'تنظیمات کوکی',
        'necessary' => 'کوکی‌های ضروری',
        'analytics' => 'کوکی‌های تحلیلی',
        'marketing' => 'کوکی‌های بازاریابی',
        'save_preferences' => 'ذخیره ترجیحات'
    ],

    // Settings
    'settings' => [
        'general' => 'تنظیمات عمومی',
        'account_settings' => 'تنظیمات حساب',
        'privacy_settings' => 'تنظیمات حریم خصوصی',
        'notification_settings' => 'تنظیمات اعلان‌ها',
        'language' => 'زبان',
        'theme' => 'تم',
        'timezone' => 'منطقه زمانی',
        'currency' => 'ارز',
        'odds_format' => 'فرمت ضرایب',
        'decimal' => 'اعشاری',
        'fractional' => 'کسری',
        'american' => 'آمریکایی',
        'email_notifications' => 'اعلان‌های ایمیل',
        'sms_notifications' => 'اعلان‌های پیامک',
        'push_notifications' => 'اعلان‌های فوری',
        'marketing_emails' => 'ایمیل‌های بازاریابی',
        'two_factor_auth' => 'احراز هویت دو مرحله‌ای',
        'change_theme' => 'تغییر تم',
        'auto_logout' => 'خروج خودکار',
        'session_timeout' => 'انقضای جلسه',
        'login_alerts' => 'هشدارهای ورود',
        'bet_confirmations' => 'تأیید شرط‌ها',
        'sound_effects' => 'جلوه‌های صوتی',
        'animations' => 'انیمیشن‌ها',
        'reduced_motion' => 'حرکت کاهش یافته'
    ],

    // Help & Guides
    'help' => [
        'getting_started' => 'شروع کار',
        'how_to_bet' => 'نحوه شرط‌بندی',
        'crypto_guide' => 'راهنمای ارز دیجیتال',
        'betting_guide' => 'راهنمای شرط‌بندی',
        'casino_guide' => 'راهنمای کازینو',
        'bonus_guide' => 'راهنمای جایزه',
        'security_guide' => 'راهنمای امنیت',
        'mobile_guide' => 'راهنمای موبایل',
        'troubleshooting' => 'عیب‌یابی',
        'video_tutorials' => 'آموزش‌های ویدیویی',
        'step_by_step' => 'راهنمای گام به گام',
        'tips_and_tricks' => 'نکات و ترفندها'
    ],

    // Errors
    'errors' => [
        'page_not_found' => 'صفحه یافت نشد',
        'access_denied' => 'دسترسی مجاز نیست',
        'server_error' => 'خطای سرور',
        'maintenance_mode' => 'سایت در حال تعمیر',
        'connection_error' => 'خطای اتصال',
        'timeout_error' => 'انقضای زمان درخواست',
        'invalid_request' => 'درخواست نامعتبر',
        'session_expired' => 'جلسه منقضی شده',
        'rate_limit_exceeded' => 'حد نرخ تجاوز شده',
        'file_not_found' => 'فایل یافت نشد',
        'permission_denied' => 'اجازه مجاز نیست',
        'validation_failed' => 'اعتبارسنجی ناموفق',
        'database_error' => 'خطای پایگاه داده',
        'network_error' => 'خطای شبکه',
        'unknown_error' => 'خطای نامشخص'
    ]
];
?>