<?php
require_once 'includes/header.php';

if (!$auth->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$user = $auth->getUser($user_id);

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $current_password = trim($_POST['current_password']);
    $new_password = trim($_POST['new_password']);
    $confirm_password = trim($_POST['confirm_password']);
    
    // بررسی ایمیل
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "لطفا یک ایمیل معتبر وارد کنید.";
    } else {
        // به روز رسانی ایمیل
        $query = "UPDATE users SET email = :email WHERE id = :user_id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(":email", $email);
        $stmt->bindParam(":user_id", $user_id);
        
        if ($stmt->execute()) {
            $_SESSION['email'] = $email;
            $success = "ایمیل با موفقیت به روز شد.";
        } else {
            $error = "خطا در به روز رسانی ایمیل.";
        }
    }
    
    // تغییر رمز عبور اگر وارد شده باشد
    if (!empty($current_password) && !empty($new_password) && !empty($confirm_password)) {
        if ($new_password !== $confirm_password) {
            $error = "رمز عبور جدید و تکرار آن مطابقت ندارند.";
        } elseif (strlen($new_password) < 6) {
            $error = "رمز عبور جدید باید حداقل 6 کاراکتر باشد.";
        } else {
            // بررسی رمز عبور فعلی
            $query = "SELECT password FROM users WHERE id = :user_id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
            $user = $stmt->fetch();
            
            if (password_verify($current_password, $user['password'])) {
                // به روز رسانی رمز عبور
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $query = "UPDATE users SET password = :password WHERE id = :user_id";
                $stmt = $db->prepare($query);
                $stmt->bindParam(":password", $hashed_password);
                $stmt->bindParam(":user_id", $user_id);
                
                if ($stmt->execute()) {
                    $success = "رمز عبور با موفقیت تغییر کرد.";
                } else {
                    $error = "خطا در تغییر رمز عبور.";
                }
            } else {
                $error = "رمز عبور فعلی اشتباه است.";
            }
        }
    }
}

// دریافت تاریخچه تراکنش‌های کاربر
$query = "SELECT * FROM transactions WHERE user_id = :user_id ORDER BY created_at DESC LIMIT 5";
$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);
$stmt->execute();
$transactions = $stmt->fetchAll();
?>

<div class="container">
    <div class="profile-container">
        <h1 data-translate="profile">Profile</h1>
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="profile-content">
            <div class="profile-info">
                <div class="info-card">
                    <h3 data-translate="personal_info">Personal Information</h3>
                    <form method="POST">
                        <div class="form-group">
                            <label for="username" data-translate="username">Username</label>
                            <input type="text" id="username" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
                            <small>نام کاربری قابل تغییر نیست</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="email" data-translate="email">Email</label>
                            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="balance" data-translate="balance">Balance</label>
                            <input type="text" id="balance" value="$<?php echo number_format($user['balance'], 2); ?>" disabled>
                        </div>
                        
                        <button type="submit" class="btn btn-primary" data-translate="save_changes">Save Changes</button>
                    </form>
                </div>
                
                <div class="info-card">
                    <h3 data-translate="change_password">Change Password</h3>
                    <form method="POST">
                        <div class="form-group">
                            <label for="current_password" data-translate="current_password">Current Password</label>
                            <input type="password" id="current_password" name="current_password">
                        </div>
                        
                        <div class="form-group">
                            <label for="new_password" data-translate="new_password">New Password</label>
                            <input type="password" id="new_password" name="new_password">
                        </div>
                        
                        <div class="form-group">
                            <label for="confirm_password" data-translate="confirm_password">Confirm Password</label>
                            <input type="password" id="confirm_password" name="confirm_password">
                        </div>
                        
                        <button type="submit" class="btn btn-primary" data-translate="change_password">Change Password</button>
                    </form>
                </div>
            </div>
            
            <div class="profile-history">
                <div class="info-card">
                    <h3 data-translate="recent_transactions">Recent Transactions</h3>
                    
                    <?php if (count($transactions) > 0): ?>
                        <table class="transactions-table">
                            <thead>
                                <tr>
                                    <th data-translate="type">Type</th>
                                    <th data-translate="amount">Amount</th>
                                    <th data-translate="status">Status</th>
                                    <th data-translate="date">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($transactions as $transaction): ?>
                                <tr>
                                    <td>
                                        <?php 
                                        $typeLabels = [
                                            'deposit' => 'واریز',
                                            'withdraw' => 'برداشت',
                                            'bet' => 'شرط',
                                            'win' => 'برد'
                                        ];
                                        echo $typeLabels[$transaction['type']] ?? $transaction['type'];
                                        ?>
                                    </td>
                                    <td>$<?php echo number_format($transaction['amount'], 2); ?></td>
                                    <td>
                                        <?php 
                                        $statusLabels = [
                                            'pending' => 'در انتظار',
                                            'completed' => 'تکمیل شده',
                                            'cancelled' => 'لغو شده'
                                        ];
                                        echo $statusLabels[$transaction['status']];
                                        ?>
                                    </td>
                                    <td><?php echo date('Y-m-d H:i', strtotime($transaction['created_at'])); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        
                        <a href="history.php" class="btn btn-secondary" data-translate="view_all">View All</a>
                    <?php else: ?>
                        <p data-translate="no_transactions">No transactions found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>