-- ایجاد دیتابیس
CREATE DATABASE IF NOT EXISTS crashify_db;
USE crashify_db;

-- جدول کاربران
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `language` varchar(5) DEFAULT 'en',
  `is_admin` tinyint(1) DEFAULT '0',
  `is_blocked` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- جدول تراکنش‌ها
CREATE TABLE `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` enum('deposit','withdraw','bet','win') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `status` enum('pending','completed','cancelled') DEFAULT 'pending',
  `details` text,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- جدول بازی‌ها
CREATE TABLE `games` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
-- تغییر ساختار جدول games برای رفع خطا
ALTER TABLE `games` MODIFY `bet_amount` DECIMAL(15,2) DEFAULT 0;  `multiplier` decimal(10,2) DEFAULT NULL,
  `cashout` decimal(10,2) DEFAULT NULL,
  `result` enum('win','lose','in progress') DEFAULT 'in progress',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `crashed_at` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `games_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- جدول شرط‌ها
CREATE TABLE `bets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `auto_cashout` decimal(10,2) DEFAULT NULL,
  `cashed_out` decimal(10,2) DEFAULT NULL,
  `profit` decimal(15,2) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `game_id` (`game_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `bets_ibfk_1` FOREIGN KEY (`game_id`) REFERENCES `games` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bets_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- جدول تنظیمات
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(50) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- داده‌های اولیه تنظیمات
INSERT INTO `settings` (`key`, `value`) VALUES
('site_name', 'Crashify'),
('min_bet', '1'),
('max_bet', '1000'),
('default_language', 'en'),
('maintenance_mode', '0'),
('house_edge', '2');

-- جدول زبان‌ها
CREATE TABLE `language_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `en` text,
  `fa` text,
  `ar` text,
  `tr` text,
  `de` text,
  `fr` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- داده‌های اولیه ترجمه
INSERT INTO `language_translations` (`key`, `en`, `fa`, `ar`, `tr`, `de`, `fr`) VALUES
('welcome', 'Welcome', 'خوش آمدید', 'أهلا بك', 'Hoş geldiniz', 'Willkommen', 'Bienvenue'),
('login', 'Login', 'ورود', 'تسجيل الدخول', 'Giriş', 'Anmelden', 'Connexion'),
('register', 'Register', 'ثبت نام', 'تسجيل', 'Kayıt', 'Registrieren', 'Inscription'),
('username', 'Username', 'نام کاربری', 'اسم المستخدم', 'Kullanıcı adı', 'Benutzername', 'Nom d\'utilisateur'),
-- ... ادامه ترجمه برای تمام متن‌های سایت

-- جدول تیکت‌های پشتیبانی
CREATE TABLE `support_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `status` enum('open','pending','closed') DEFAULT 'open',
  `priority` enum('low','medium','high') DEFAULT 'medium',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `support_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- جدول پاسخ‌های پشتیبانی
CREATE TABLE `support_replies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `is_admin` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `support_replies_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `support_replies_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;