<?php
require_once 'includes/header.php';

if (!$auth->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

// دریافت اطلاعات کاربر
$user_id = $_SESSION['user_id'];
$user = $auth->getUser($user_id);
$game_history = $functions->getUserGameHistory($user_id, 5);
?>

<div class="container">
    <div class="dashboard">
        <h1><?php echo $translations['welcome']; ?>, <?php echo $_SESSION['username']; ?>!</h1>
        
        <div class="dashboard-cards">
            <div class="card">
                <h3><?php echo $translations['balance']; ?></h3>
                <p class="balance">$<?php echo number_format($_SESSION['balance'], 2); ?></p>
            </div>
            
            <div class="card">
                <h3><?php echo $translations['total_bets']; ?></h3>
                <p><?php echo count($game_history); ?></p>
            </div>
            
            <div class="card">
                <h3><?php echo $translations['last_login']; ?></h3>
                <p><?php echo date('Y-m-d H:i', strtotime($user['last_login'])); ?></p>
            </div>
        </div>
        
        <div class="recent-activity">
            <h2><?php echo $translations['recent_activity']; ?></h2>
            <table>
                <thead>
                    <tr>
                        <th><?php echo $translations['game_id']; ?></th>
                        <th><?php echo $translations['bet_amount']; ?></th>
                        <th><?php echo $translations['cashout']; ?></th>
                        <th><?php echo $translations['profit']; ?></th>
                        <th><?php echo $translations['date']; ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($game_history as $game): ?>
                    <tr>
                        <td>#<?php echo $game['id']; ?></td>
                        <td>$<?php echo number_format($game['amount'], 2); ?></td>
                        <td><?php echo $game['cashed_out'] ? $game['cashed_out'] . 'x' : '-'; ?></td>
                        <td class="<?php echo $game['profit'] > 0 ? 'profit' : 'loss'; ?>">
                            <?php echo $game['profit'] ? '$' . number_format($game['profit'], 2) : '-'; ?>
                        </td>
                        <td><?php echo date('Y-m-d H:i', strtotime($game['created_at'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <div class="quick-actions">
            <h2><?php echo $translations['quick_actions']; ?></h2>
            <div class="action-buttons">
                <a href="<?php echo SITE_URL; ?>" class="btn"><?php echo $translations['play_now']; ?></a>
                <a href="<?php echo SITE_URL; ?>/history.php" class="btn"><?php echo $translations['view_history']; ?></a>
                <a href="<?php echo SITE_URL; ?>/profile.php" class="btn"><?php echo $translations['edit_profile']; ?></a>
            </div>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>