<?php
require_once '../includes/header.php';

if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    header("Location: ../login.php");
    exit;
}

// دریافت آمار سایت
$query = "SELECT 
            (SELECT COUNT(*) FROM users) as total_users,
            (SELECT COUNT(*) FROM users WHERE last_login >= NOW() - INTERVAL 5 MINUTE) as online_users,
            (SELECT SUM(amount) FROM transactions WHERE type = 'deposit' AND status = 'completed') as total_deposits,
            (SELECT SUM(amount) FROM transactions WHERE type = 'withdraw' AND status = 'completed') as total_withdrawals,
            (SELECT SUM(amount) FROM bets) as total_bets,
            (SELECT SUM(profit) FROM bets WHERE profit > 0) as total_profits";

$stmt = $db->prepare($query);
$stmt->execute();
$stats = $stmt->fetch();

// دریافت تراکنش‌های اخیر
$query = "SELECT t.*, u.username 
          FROM transactions t 
          JOIN users u ON t.user_id = u.id 
          ORDER BY t.created_at DESC 
          LIMIT 5";
$stmt = $db->prepare($query);
$stmt->execute();
$recent_transactions = $stmt->fetchAll();

// دریافت بازی‌های اخیر
$query = "SELECT g.*, COUNT(b.id) as bet_count, 
                 SUM(b.amount) as total_bet, 
                 MAX(b.cashed_out) as max_cashout 
          FROM games g 
          LEFT JOIN bets b ON g.id = b.game_id 
          GROUP BY g.id 
          ORDER BY g.created_at DESC 
          LIMIT 5";
$stmt = $db->prepare($query);
$stmt->execute();
$recent_games = $stmt->fetchAll();
?>

<div class="admin-container">
    <h1>Admin Dashboard</h1>
    
    <div class="admin-stats">
        <div class="stat-card">
            <h3>Total Users</h3>
            <p><?php echo $stats['total_users']; ?></p>
        </div>
        <div class="stat-card">
            <h3>Online Users</h3>
            <p><?php echo $stats['online_users']; ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Deposits</h3>
            <p>$<?php echo number_format($stats['total_deposits'], 2); ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Withdrawals</h3>
            <p>$<?php echo number_format($stats['total_withdrawals'], 2); ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Bets</h3>
            <p>$<?php echo number_format($stats['total_bets'], 2); ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Profits</h3>
            <p>$<?php echo number_format($stats['total_profits'], 2); ?></p>
        </div>
    </div>
    
    <div class="admin-content">
        <div class="recent-section">
            <h2>Recent Transactions</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_transactions as $transaction): ?>
                    <tr>
                        <td>#<?php echo $transaction['id']; ?></td>
                        <td><?php echo $transaction['username']; ?></td>
                        <td><?php echo $transaction['type']; ?></td>
                        <td>$<?php echo number_format($transaction['amount'], 2); ?></td>
                        <td><?php echo $transaction['status']; ?></td>
                        <td><?php echo date('Y-m-d H:i', strtotime($transaction['created_at'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <div class="recent-section">
            <h2>Recent Games</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Crashed At</th>
                        <th>Bets</th>
                        <th>Total Bet</th>
                        <th>Max Cashout</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent_games as $game): ?>
                    <tr>
                        <td>#<?php echo $game['id']; ?></td>
                        <td><?php echo $game['crashed_at']; ?>x</td>
                        <td><?php echo $game['bet_count']; ?></td>
                        <td>$<?php echo number_format($game['total_bet'], 2); ?></td>
                        <td><?php echo $game['max_cashout'] ? $game['max_cashout'] . 'x' : '-'; ?></td>
                        <td><?php echo date('Y-m-d H:i', strtotime($game['created_at'])); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once '../includes/footer.php';
?>